<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use App\Http\Controllers\FcmController;
use Illuminate\Support\Facades\Log;

class KycStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:kyc-status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send FCM notification to admin for users with pending KYC status';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {

        $pendingUsers = User::whereHas('document', function ($query) {
            $query->where('status', 'Pending');
        })->with('document')->get();


        if ($pendingUsers->isEmpty()) {
            $this->info('No users with pending KYC found.');
            return;
        }

        $notification = new FcmController();

        foreach ($pendingUsers as $user) {
            $message = "KYC still pending for user: {$user->name}";
            $notification->sendAdminNotification("KYC Reminder", $message);
        }
        $this->info('KYC Pending notifications sent to admin.');
    }

}
