<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class GroupMessageDeleted implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $messageId;

    public function __construct($messageId)
    {
        $this->messageId = $messageId;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('group-chat.' . $this->messageId);
    }

    public function broadcastAs(): string
    {
        return 'group-message-deleted';
    }

    public function broadcastWith(): array
    {
        return [
            'id' => $this->messageId,
        ];
    }
}
