<?php

namespace App\Events;

use App\Models\GroupMessage;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class GroupMessageSent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $message;
    public $user;

    public function __construct(GroupMessage $message)
    {
        $this->message = $message;
        $this->user = $message->user;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('group-chat.' . $this->message->group_id);
    }

    public function broadcastAs(): string
    {
        return 'group-message';
    }

    public function broadcastWith(): array
    {
        return [
            'message' => $this->message->message,
            'user_id' => $this->message->user_id,
            'user_name' => $this->user->name,
            'created_at' => $this->message->created_at->toDateTimeString(),
        ];
    }
}
