<?php

namespace App\Events;

use App\Models\Chat;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Support\Facades\Log;

class MessageSent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets;

    public $message;
    public $user;
    public $receiverId;
    public $createdAt; // Add this line to store the formatted timestamp


    // Constructor to pass data when event is triggered
    public function __construct($message, $user, $receiverId, $createdAt)
    {
        $this->message = $message;
        $this->user = $user;
        $this->receiverId = $receiverId;
        $this->createdAt = $createdAt; // Store the formatted timestamp
    }

    // Broadcast channel
    public function broadcastOn()
    {
        return new Channel('admin-messages.' . $this->receiverId);
    }

    // Broadcast event name
    public function broadcastAs()
    {
        return 'admin-message';
    }
}
