<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FcmController;
use App\Models\ApiRecharge;
use App\Models\GlobalRecharge;
use App\Models\GlobalRechargeOrder;
use App\Models\Recharge;
use App\Models\Settings;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;

class OrderController extends Controller
{
    //todo: for recharge
    public function pendingRecharge(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $recharges = Recharge::where('status', 'pending')->latest()->get();
        return view('recharge.pending', compact('dashboard', 'settings', 'recharges'));
    }

    public function successRecharge(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $recharges = Recharge::where('status', 'accepted')->latest()->get();
        return view('recharge.pending', compact('dashboard', 'settings', 'recharges'));
    }

    public function rejectedRecharge(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $recharges = Recharge::where('status', 'rejected')->latest()->get();
        return view('recharge.pending', compact('dashboard', 'settings', 'recharges'));
    }

    public function changeStatus(Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'status' => 'required'
        ], [
            'status.required' => 'Status is required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $update = Recharge::findOrFail($request->recharge_id);
        $update->update([
            'status' => $request->status
        ]);

        $notification = [
            'message' => 'Status updated successfully!',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function rejectRecharge(Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'reason' => 'required'
        ], [
            'reason.required' => 'Write Recharge Rejected Reason',
        ]);

        if ($validator->fails()) {

            $notification = [
                'message' => $validator->errors()->first(),
                'alert-type' => 'error'
            ];

            return redirect()->back()->with($notification);
        }

        $update = Recharge::findOrFail($request->reject_id);
        $update->update([
            'status' => 'rejected',
            'reason' => $request->reason
        ]);

        $update->user->balance += $update->amount;
        $update->user->update();

        $notification = new FcmController();
        $notification->sendFcmNotification($update->user->id, 'Global Recharge', $update->operator . ' this recharge is rejected and refunded');

        $notification = [
            'message' => 'This recharge is rejected successfully!',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);

    }

    public function deleteRecharge($id): RedirectResponse
    {
        $recharge = Recharge::findOrFail($id);
        if (!$recharge) {
            return redirect()->back()->with([
                'message' => 'Service not found!',
                'alert-type' => 'error'
            ]);
        }
        $recharge->delete();

        $notification = [
            'message' => 'This recharge is deleted successfully!',
            'alert-type' => 'success'
        ];
        return redirect()->back()->with($notification);
    }

}
