<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ApiRecharge;
use App\Models\Bank;
use App\Models\Settings;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use GuzzleHttp\Client;

class RechargeController extends Controller
{
   public function apiIndex(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);

        $apiRecharge = ApiRecharge::first();
        $balance = 'N/A';

        if ($apiRecharge) {
            try {
                $client = new Client();

                $response = $client->get($apiRecharge->api_url . "/api/recharge/balance", [
                    'headers' => [
                        'Content-Type' => 'application/json',
                        'CD-API-KEY' => $apiRecharge->api_key,
                    ],
                    'timeout' => 10, // optional: API slow হলে fallback
                ]);

                $result = json_decode($response->getBody(), true);

                if (isset($result['data']['balance'])) {
                    $balance = $result['data']['balance'];
                }
            } catch (\Exception $e) {
                \Log::error("API Balance Check Failed: " . $e->getMessage());
            }
        }

        return view('recharge.recharge_api', compact('dashboard', 'settings', 'apiRecharge', 'balance'));
    }

    public function apiUpdate(Request $request): RedirectResponse
    {
        Apirecharge::first()->update([
            'api_url' => $request->api_url,
            'api_key' => $request->api_key,
        ]);

        $notification = [
            'message' => 'Recharge API Updated Successfully',
            'alert-type' => 'success',
        ];

        return back()->with($notification);
    }

}