<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FcmController;
use App\Models\GlobalMobileBanking;
use App\Models\MBankingOrder;
use App\Models\MobileBanking;
use App\Models\Settings;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Illuminate\View\View;

class mBankingController extends Controller
{
    //==============> Mobile Banking <==============
    public function index(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $mbank_data = MobileBanking::all()->sortByDesc('created_at');
        return view('mobile_banking.index', compact('dashboard', 'settings', 'mbank_data'));
    }

    public function add_mobile_bank(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        return view('mobile_banking.add', compact('dashboard', 'settings'));
    }

    public function store_mobile_bank(Request $request): RedirectResponse
    {

        $validator = Validator::make(request()->all(), [
            'name' => 'required|unique:mobile_bankings,name',
            'logo' => 'required|image|mimes:jpeg,png,jpg,|max:2048',
        ], [
            'name.required' => 'Please enter mobile bank name',
            'name.unique' => 'Mobile bank name already exists',
            'logo.required' => 'Please enter mobile bank logo',
            'logo.image' => 'Please upload logo',
            'logo.mimes' => 'Please upload JPG, PNG, JPEG',
            'logo.max' => 'Maximum upload file size 2MB',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $store = new MobileBanking();
        $store->name = $request->name;
        $store->slug = Str::slug($request->name);

        if ($request->hasFile('logo')) {
            $file = $request->file('logo');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = 'upload/mbanking/' . $fileName;
            $file->move(public_path('upload/mbanking/'), $fileName);
            $store->logo = $path; // Store the file path in the database
        }

        $status = $request->has('status') == 'on' ? true : false;
        $store->status = $status;
        $store->save();

        $notification = [
            'message' => $request->name . ' added successfully',
            'alert-type' => 'success',
        ];

        return back()->with($notification);
    }

    public function edit_mobile_bank($id): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $mbank = MobileBanking::findOrFail($id);
        return view('mobile_banking.edit', compact('dashboard', 'settings', 'mbank'));
    }

    public function delete_mobile_bank($id): RedirectResponse
    {
        $mBankDelete = MobileBanking::findOrFail($id);
        if ($mBankDelete->logo && File::exists(public_path($mBankDelete->logo))) {
            File::delete(public_path($mBankDelete->logo));
        }
        $mBankDelete->delete();
        $notification = [
            'message' => $mBankDelete->name . ' deleted successfully',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function update_mobile_bank(Request $request, $id): RedirectResponse
    {
        $validator = Validator::make(request()->all(), [
            'name' => ['nullable', Rule::unique('mobile_bankings')->ignore($id)],
            'slug' => ['nullable', Rule::unique('mobile_bankings')->ignore($id)],
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,|max:2048',
        ], [
            'name.required' => 'Please enter mobile bank name',
            'name.unique' => 'Mobile bank name already exists',
            'logo.required' => 'Please enter mobile bank logo',
            'logo.image' => 'Please upload logo',
            'logo.mimes' => 'Please upload JPG, PNG, JPEG',
            'logo.max' => 'Maximum upload file size 2MB',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $update = MobileBanking::findOrFail($id);
        $update->name = $request->name;
        $update->slug = Str::slug($request->name);

        if ($request->hasFile('logo')) {

            if ($update->logo && File::exists(public_path($update->logo))) {
                File::delete(public_path($update->logo));
            }

            $file = $request->file('logo');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = 'upload/mbanking/' . $fileName;
            $file->move(public_path('upload/mbanking/'), $fileName);
            $update->logo = $path; // Store the file path in the database
        }

        $status = $request->has('status') == 'on' ? true : false;
        $update->status = $status;
        $update->update();

        $notification = [
            'message' => $request->name . ' updated successfully',
            'alert-type' => 'success',
        ];

        return back()->with($notification);
    }

    //==============> End Mobile Banking <==============

    //==============> Global Mobile Banking <==============

    public function globalMobileBanking(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $g_mbank_data = GlobalMobileBanking::all()->sortByDesc('created_at');
        return view('mobile_banking.global.index', compact('dashboard', 'settings', 'g_mbank_data'));
    }

    public function add_global_mobile_bank(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        return view('mobile_banking.global.add', compact('dashboard', 'settings'));
    }

    public function store_global_mobile_bank(Request $request): RedirectResponse
    {

        $validator = Validator::make(request()->all(), [
            'name' => 'required|unique:global_mobile_bankings,name',
            'logo' => 'required|image|mimes:jpeg,png,jpg,|max:2048',
        ], [
            'name.required' => 'Please enter mobile bank name',
            'name.unique' => 'Mobile bank name already exists',
            'logo.required' => 'Please enter mobile bank logo',
            'logo.image' => 'Please upload logo',
            'logo.mimes' => 'Please upload JPG, PNG, JPEG',
            'logo.max' => 'Maximum upload file size 2MB',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $store = new GlobalMobileBanking();
        $store->name = $request->name;
        $store->slug = Str::slug($request->name);

        if ($request->hasFile('logo')) {
            $file = $request->file('logo');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = 'upload/g_mbanking/' . $fileName;
            $file->move(public_path('upload/g_mbanking/'), $fileName);
            $store->logo = $path; // Store the file path in the database
        }

        $status = $request->has('status') == 'on' ? true : false;
        $store->status = $status;
        $store->save();

        $notification = [
            'message' => $request->name . ' added successfully',
            'alert-type' => 'success',
        ];

        return back()->with($notification);
    }

    public function edit_global_mobile_bank($id): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $g_mbank = GlobalMobileBanking::findOrFail($id);
        return view('mobile_banking.global.edit', compact('dashboard', 'settings', 'g_mbank'));
    }

    public function delete_global_mobile_bank($id): RedirectResponse
    {
        $g_mBankDelete = GlobalMobileBanking::findOrFail($id);
        if ($g_mBankDelete->logo && File::exists(public_path($g_mBankDelete->logo))) {
            File::delete(public_path($g_mBankDelete->logo));
        }
        $g_mBankDelete->delete();
        $notification = [
            'message' => $g_mBankDelete->name . ' deleted successfully',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function update_global_mobile_bank(Request $request, $id): RedirectResponse
    {
        $validator = Validator::make(request()->all(), [
            'name' => ['nullable', Rule::unique('global_mobile_bankings')->ignore($id)],
            'slug' => ['nullable', Rule::unique('global_mobile_bankings')->ignore($id)],
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,|max:2048',
        ], [
            'name.required' => 'Please enter mobile bank name',
            'name.unique' => 'Mobile bank name already exists',
            'logo.required' => 'Please enter mobile bank logo',
            'logo.image' => 'Please upload logo',
            'logo.mimes' => 'Please upload JPG, PNG, JPEG',
            'logo.max' => 'Maximum upload file size 2MB',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $update = GlobalMobileBanking::findOrFail($id);
        $update->name = $request->name;
        $update->slug = Str::slug($request->name);

        if ($request->hasFile('logo')) {

            if ($update->logo && File::exists(public_path($update->logo))) {
                File::delete(public_path($update->logo));
            }

            $file = $request->file('logo');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = 'upload/g_mbanking/' . $fileName;
            $file->move(public_path('upload/g_mbanking/'), $fileName);
            $update->logo = $path; // Store the file path in the database
        }

        $status = $request->has('status') == 'on' ? true : false;
        $update->status = $status;
        $update->update();

        $notification = [
            'message' => $request->name . ' updated successfully',
            'alert-type' => 'success',
        ];

        return back()->with($notification);
    }


    // for Mobile banking actions
    public function mbankingPending(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $items = MBankingOrder::where('status', 'pending')->latest()->get();
        return view('mobile_banking.mBanking_order', compact('dashboard', 'settings', 'items'));
    }

    public function mbankingSuccess(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $items = MBankingOrder::where('status', 'approved')->latest()->get();
        return view('mobile_banking.mBanking_order', compact('dashboard', 'settings', 'items'));
    }

    public function mbankingRejected(): View
    {
        $dashboard = User::where('role', 'admin')->where('id', auth()->id())->first();
        $settings = Settings::findOrFail(1);
        $items = MBankingOrder::where('status', 'rejected')->latest()->get();
        return view('mobile_banking.mBanking_order', compact('dashboard', 'settings', 'items'));
    }

    public function mbankingApproved(Request $request): RedirectResponse
    {
        $notificationController = new FcmController();
        $update = MBankingOrder::where('id', $request->success_id)->first();
        $update->update([
            'status' => 'approved',
            'last_number' => $request->last_number,
            'mbank_number' => $request->change_number ?? $update->mbank_number,
            'trx_id' => $request->trx_id
        ]);

        $notificationController->sendFcmNotification($update->user_id, $update->mbank_name, 'Your ' . $update->mbank_name . ' service is approved successfully');

        $notification = [
            'message' => 'This ' . $update->mbank_name . ' service is approved successfully',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);

    }

    public function mbankingOrderRejected(Request $request): RedirectResponse
    {
        $notificationController = new FcmController();

        $validator = Validator::make($request->all(), [
            'reason' => 'required'
        ], [
            'reason.required' => 'Write Mobile Banking Rejected Reason',
        ]);

        if ($validator->fails()) {

            $notification = [
                'message' => $validator->errors()->first(),
                'alert-type' => 'error'
            ];

            return redirect()->back()->with($notification);
        }

        $update = MBankingOrder::where('id', $request->reject_id)->first();
        $update->update([
            'status' => 'rejected',
            'reason' => $request->reason
        ]);

        $refundAmount = $update->amount + $update->fee;

        $update->user->balance += $refundAmount;
        $update->user->balance -= $update->commission;
        $update->user->update();

        $notificationController->sendFcmNotification($update->user_id, $update->mbank_name, 'Your ' . $update->mbank_name . ' service is rejected & refunded successfully');

        $notification = [
            'message' => 'This ' . $update->mbank_name . ' service is rejected successfully!',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);

    }

    public function mbankingDelete($id): RedirectResponse
    {
        $delete = MBankingOrder::findOrFail($id);
        $delete->delete();

        $notification = [
            'message' => 'This service is deleted successfully!',
            'alert-type' => 'success'
        ];
        return redirect()->back()->with($notification);
    }

}
