<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FcmController;
use App\Models\AddMoneyOrder;
use App\Models\AutoPay;
use App\Models\BankGateway;
use App\Models\MobileBanking;
use App\Models\MobileGateway;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use PhpParser\Node\Expr\Cast\Double;

class AddMoneyController extends Controller
{
    public function autoAddMoneyKey(): JsonResponse
    {
        $key = AutoPay::findOrFail(1);
        return response()->json([
            'status' => true,
            'key' => $key->api_key,
        ]);
    }

    public function mobileAddMoney(): JsonResponse
    {
        $items = MobileGateway::all();
        $data = $items->map(function ($items) {
            return [
                'id' => $items->id,
                'name' => $items->name,
                'number' => $items->number,
                'sending_type' => $items->sending_type,
                'logo' => url($items->logo),
            ];
        });


        return response()->json([
            'status' => true,
            'data' => $data,
        ]);
    }

    public function bankAddMoney(): JsonResponse
    {
        $items = BankGateway::all();
        $data = $items->map(function ($items) {
            return [
                'id' => $items->id,
                'name' => $items->bank_name,
                'holder_name' => $items->ac_holder_name,
                'holder_number' => $items->ac_holder_number,
                'ibn' => $items->ibn_no,
                'branch' => $items->branch_name,
                'country' => $items->country_name,
                'logo' => url($items->logo),
            ];
        });

        return response()->json([
            'status' => true,
            'data' => $data,
        ]);
    }

    public function autoAddMoney(Request $request): JsonResponse
    {
        if ($request->get('status') !== 'COMPLETED') {
            return response()->json([
                'status' => false,
                'errors' => 'Transaction not completed'
            ]);
        }

        $user = User::findOrFail(Auth::id());
        $amount = $request->get('amount');

        $user->balance += $amount;
        $user->update();

        AddMoneyOrder::create([
            'user_id' => Auth::id(),
            'method_name' => $request->get('payment_method'),
            'holder_name' => $request->get('name'),
            'account_number' => $request->get('email'),
            'amount' => $request->get('amount'),
            'sent_date' => Carbon::now()->format('D, d M Y H:i:s a'),
            'trx_id' => $request->get('trx_id'),
            'add_money' => 'AUTO',
            'status' => 'success',
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Balance added successfully'
        ]);

    }

    public function bankDeposit(Request $request): JsonResponse
    {
        $user = Auth::user();
        if ($user->pin != $request->pin){
            return response()->json([
                'status' => false,
                'errors' => 'Your pin is wrong'
            ]);
        }

        $gateway = BankGateway::findOrFail($request->get('id'));
        if ($request->has('screenshot')) {
            $updateImage = base64_decode($request->get('screenshot'));
            $fileName = Auth::user()->phone . "_deposit_" . time() . '.png';
            $path = 'upload/screenshots/' . $fileName;
            file_put_contents(public_path($path), $updateImage);

            AddMoneyOrder::create([
                'user_id' => Auth::id(),
                'method_name' => $gateway->bank_name,
                'holder_name' => $request->get('acName'),
                'account_number' => $request->get('acNumber'),
                'amount' => $request->get('amount'),
                'sent_date' => Carbon::now()->format('D, d M Y H:i:s a'),
                'add_money' => 'Bank',
                'screenshot' => $path,
            ]);
        }

        $notification = new FcmController();
        $notification->sendAdminNotification("Add Money", $request->get('bank_name') . ' addmoney request from ' . Auth::user()->name);

        return response()->json([
            'status' => true,
            'message' => 'Balance adding request send successfully'
        ]);


    }

    public function mobileDeposit(Request $request): JsonResponse
    {
        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return response()->json([
                'status' => false,
                'errors' => 'Your pin is wrong'
            ]);
        }

        $gateway = MobileGateway::findOrFail($request->get('id'));
        AddMoneyOrder::create([
            'user_id' => Auth::id(),
            'method_name' => $gateway->name,
            'holder_name' => Auth::user()->name,
            'account_number' => $request->get('senderNumber'),
            'amount' => $request->get('amount'),
            'sent_date' => Carbon::now()->format('D, d M Y H:i:s a'),
            'trx_id' => $request->get('trxID'),
            'add_money' => 'MobileBanking',
        ]);


        $notification = new FcmController();
        $notification->sendAdminNotification("Add Money", $gateway->name . ' addmoney request from ' . Auth::user()->name);

        return response()->json([
            'status' => true,
            'message' => 'Balance adding request send successfully'
        ]);
    }


}
