<?php

namespace App\Http\Controllers\Auth;


use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Models\Settings;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        $settings = Settings::findOrFail(1);
        return view('auth.login', compact('settings'));
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();
        $request->session()->regenerate();
        $url = '';
        $msg = '';
        $type = '';

        if ($request->user()->role === 'admin') {
            $url = '/admin';
            $msg = 'Welcome back ' . $request->user()->name . '!';
            $type = 'success';
        }

        if ($request->user()->role === 'retailer') {
            $url = '/user';
            $msg = 'Welcome back ' . $request->user()->name . '!';
            $type = 'success';
        }
        $notification = [
            'message' => $msg,
            'alert-type' => $type,
        ];
        return redirect()->intended($url)->with($notification)->withInput();
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        // Log out the user
        Auth::guard('web')->logout();

        // Invalidate the current session
        $request->session()->invalidate();

        // Regenerate session token to prevent CSRF attacks
        $request->session()->regenerateToken();

        return redirect('/');
    }
}
