<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\AboutSection;
use App\Models\DownloadSection;
use App\Models\FeatureSection;
use App\Models\HeaderSection;
use App\Models\Screenshot;
use App\Models\ScreenshotSection;
use App\Models\Settings;
use Google\Service\Calendar\Setting;
use Illuminate\Http\Request;
use Illuminate\View\View;

class FrontendController extends Controller
{
    public function index(): View
    {
        $hero = HeaderSection::first();
        $about = AboutSection::first();
        $feature = FeatureSection::first();
        $download = DownloadSection::first();
        $settings = Settings::first();
        $ssSection = ScreenshotSection::first();
        $screenshots = Screenshot::all();
        return view('frontend.index', compact('hero', 'about', 'feature', 'download', 'settings', 'ssSection', 'screenshots'));
    }
}
