<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FcmController;
use App\Models\AddMoneyOrder;
use App\Models\Bank;
use App\Models\BankGateway;
use App\Models\BankTransfer;
use App\Models\Billing;
use App\Models\BillPayment;
use App\Models\Commission;
use App\Models\DriveOrder;
use App\Models\MBankingOrder;
use App\Models\MobileBanking;
use App\Models\MobileGateway;
use App\Models\Package;
use App\Models\Recharge;
use App\Models\Remittance;
use App\Models\RemittanceOrder;
use App\Models\SendmoneyOrder;
use App\Models\Settings;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;
use function Symfony\Component\String\u;

class UserDashController extends Controller
{
    public function index(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        return view('frontend.dashboard.index', compact('settings', 'user'));
    }

    public function bankAddMoney(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $directBanks = BankGateway::orderBy('id', 'desc')->paginate(10);
        return view('frontend.dashboard.pages.bank_add_money', compact('settings', 'user', 'directBanks'));
    }

    public function mobileAddMoney(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $mBankings = MobileGateway::orderBy('id', 'desc')->paginate(10);
        return view('frontend.dashboard.pages.mobile_add_money', compact('settings', 'user', 'mBankings'));
    }

    public function proceedMAddMoney($id): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $mBanking = MobileGateway::findOrFail($id);
        return view('frontend.dashboard.pages.proceed_mobile_add_money', compact('settings', 'user', 'mBanking'));
    }

    public function proceedBAddMoney($id): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $bank = BankGateway::findOrFail($id);
        return view('frontend.dashboard.pages.proceed_bank_add_money', compact('settings', 'user', 'bank'));
    }

    public function sendMoney(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        return view('frontend.dashboard.pages.send_money', compact('settings', 'user'));
    }

    public function recharge(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        return view('frontend.dashboard.pages.recharge', compact('settings', 'user'));
    }

    public function payBill(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $payBills = Billing::all();
        return view('frontend.dashboard.pages.pay_bill', compact('settings', 'user', 'payBills'));
    }

    public function remittance(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $remittance = Remittance::all();
        return view('frontend.dashboard.pages.remittance', compact('settings', 'user', 'remittance'));
    }

    public function banking(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $banks = Bank::all();
        return view('frontend.dashboard.pages.bank_transfer', compact('settings', 'user', 'banks'));
    }

    public function mBanking(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $mBanks = MobileBanking::all();
        return view('frontend.dashboard.pages.mobile_transfer', compact('settings', 'user', 'mBanks'));
    }

    public function bankingView($id): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $bank = Bank::findOrFail($id);
        return view('frontend.dashboard.pages.proceed_bank_transfer', compact('settings', 'user', 'bank'));
    }

    public function mBankingView($id): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        $mBank = MobileBanking::findOrFail($id);
        return view('frontend.dashboard.pages.proceed_m_bank_transfer', compact('settings', 'user', 'mBank'));
    }


    public function mBankingDeposit(Request $request, $mId): RedirectResponse
    {
        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }
        $gateway = MobileGateway::findOrFail($mId);
        AddMoneyOrder::create([
            'user_id' => $user->id,
            'method_name' => $gateway->name,
            'holder_name' => $user->name,
            'account_number' => $request->sender_number,
            'amount' => $request->amount,
            'sent_date' => Carbon::now()->format('D, d M Y H:i:s a'),
            'trx_id' => $request->trx_id,
            'add_money' => 'MobileBanking',
        ]);

        $notification = new FcmController();
        $notification->sendAdminNotification("Add Money", $gateway->name . ' addmoney request from ' . $user->name);

        $notification = [
            'message' => 'অ্যাড মানি রিকুয়েস্ট সফল ভাবে পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);

    }

    public function bankingDeposit(Request $request, $bId): RedirectResponse
    {
        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        $gateway = BankGateway::findOrFail($bId);
        if ($request->has('screenshot')) {
            $file = $request->file('screenshot');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $path = 'upload/screenshot/' . $fileName;
            $file->move(public_path('upload/screenshot/'), $fileName);

            AddMoneyOrder::create([
                'user_id' => $user->id,
                'method_name' => $gateway->bank_name,
                'holder_name' => $user->name,
                'account_number' => $request->sender_number,
                'amount' => $request->amount,
                'sent_date' => Carbon::now()->format('D, d M Y H:i:s a'),
                'add_money' => 'Bank',
                'screenshot' => $path,
            ]);
        }

        $notification = new FcmController();
        $notification->sendAdminNotification("Add Money", $gateway->bank_name . ' add money request from ' . $user->name);

        $notification = [
            'message' => 'অ্যাড মানি রিকুয়েস্ট সফল ভাবে পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function sendMoneyProceed(Request $request)
    {
        $notification = new FcmController();
        $user = Auth::user();
        $recipient = User::where('phone', $request->account_number)->first();

        if (!$recipient) {
            return back()->withErrors(['account_number' => 'একাউন্ট খুজে পাওয়া যায়নি।'])->withInput();
        }

        if ($request->pin !== $user->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        if ($user->balance < $request->amount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();

        }

        if ($recipient->phone === $user->phone) {
            return back()->withErrors(['account_number' => 'আপনার নিজের নাম্বার এ টাকা পাঠাতে পারবেন না।'])->withInput();

        }

        DB::beginTransaction();

        try {
            $user->decrement('balance', $request->get('amount'));

            if ($recipient) {
                $recipient->increment('balance', $request->get('amount'));

                $notification->sendFcmNotification(
                    $recipient->id,
                    'Received Money',
                    'You received ' . $request->get('amount') . ' from ' . $user->phone
                );
            }

            SendmoneyOrder::create([
                'user_id' => $user->id,
                'ac_number' => $request->account_number,
                'amount' => $request->amount,
                'status' => $recipient ? 'accepted' : 'pending'
            ]);

            $notification->sendAdminNotification("SendMoney", 'Send Money from ' . $user->first_name . ' ' . $user->last_name);

            DB::commit();

            $notification = [
                'message' => $recipient->name . ' এর কাছে সফলভাবে সেন্ড মানি করা হয়েছে',
                'alert-type' => 'success'
            ];

            return redirect()->back()->with($notification);

        } catch (\Exception $e) {
            DB::rollBack();
            $notification = [
                'message' => 'ট্রাঞ্জেকশন ব্যর্থ হয়েছে। একটু পরে আবার চেষ্টা করুন',
                'alert-type' => 'success'
            ];

            return redirect()->back()->with($notification);
        }
    }

    public function rechargeProceed(Request $request)
    {
        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }
        $number = $request->number;
        $type = $request->type;

        $commissionRate = Commission::findOrFail(1);  // Fetch default or specific commission rate
        $calculate = 0;
        if ($commissionRate->status == 'active') {
            $calculate = $request->amount * ($commissionRate->amount / 100);
            $finalAmount = $request->amount - $calculate;
        } else {
            $finalAmount = $request->amount;
        }

        if ($user->balance < $finalAmount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();
        }

        Recharge::create([
            'user_id' => $user->id,
            'number' => $number,
            'sub_operator' => $request->operator,
            'operator_name' => $request->operator,
            'type' => $type,
            'amount' => $request->amount,
            'commission' => $calculate,
        ]);

        $user->decrement('balance', $finalAmount);

        $notification = new FcmController();
        $notification->sendAdminNotification("Recharge request", $request->get('operator_name') . ' recharge request from ' . $user->name);

        $notification = [
            'message' => $request->operator_name . ' সফলভাবে রিচার্জ এর রিকোয়েস্ট পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function payBillProceed(Request $request)
    {
        $amount = $request->get('amount');
        $finalAmount = $amount;

        $charge = Commission::findOrFail(9);
        $commissionRate = Commission::findOrFail(5);

        $chargeAmount = 0;
        $commissionAmount = 0;

        if ($charge->status === 'active') {
            $chargeAmount = $charge->amount;
            $finalAmount += $chargeAmount;
        }

        if ($commissionRate->status === 'active') {
            $commissionAmount = $amount * ($commissionRate->amount / 100);
            $finalAmount -= $commissionAmount;
        }

        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        if ($user->balance < $finalAmount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();
        }

        BillPayment::create([
            'user_id' => $user->id,
            'billing_name' => $request->billing_name,
            'account_number' => $request->account_number,
            'billing_date' => $request->billing_date,
            'customer_name' => $request->customer_name,
            'customer_number' => $request->customer_number,
            'amount' => $finalAmount,
            'commission' => $commissionAmount,
            'fee' => $chargeAmount,
        ]);

        $user->decrement('balance', $finalAmount);

        $notification = new FcmController();
        $notification->sendAdminNotification("Bill Pay request", $request->get('billing_name') . ' request from ' . $user->name);

        $notification = [
            'message' => $request->billing_name . ' সফলভাবে পে-বিল এর রিকোয়েস্ট পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function remittanceProceed(Request $request)
    {
        $amount = $request->transferAmount;
        $fee = Commission::findOrFail(11);  // Fetch default or specific commission rate
        $calculate = 0;
        if ($fee->status == 'active') {
            $calculate = $amount * ($fee->amount / 100);
            $finalAmount = $amount + $calculate;
        } else {
            $finalAmount = $amount;
        }

        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        if ($user->balance < $finalAmount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();
        }

        RemittanceOrder::create([
            'user_id' => $user->id,
            'recipient_number' => $request->recipientNumber,
            'recipient_name' => $request->recipientName,
            'bank_name' => $request->bankName,
            'transfer_amount' => $request->transferAmount,
            'sender_number' => $request->senderNumber,
            'sender_name' => $request->senderName,
            'fee' => $calculate,
        ]);

        $user->balance -= $finalAmount;
        $user->update();

        $notification = new FcmController();
        $notification->sendAdminNotification("Remittance request", $request->get('bankName') . ' is purchased from ' . $user->name);

        $notification = [
            'message' => ' সফলভাবে রেমিট্যান্স পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function bankingProceed(Request $request, $name)
    {
        $amount = $request->amount;
        $finalAmount = $amount;

        $charge = Commission::findOrFail(7);
        $commissionRate = Commission::findOrFail(6);

        $chargeAmount = 0;
        $commissionAmount = 0;

        if ($charge->status === 'active') {
            $chargeAmount = $amount * ($charge->amount / 100);
            $finalAmount += $chargeAmount;
        }

        if ($commissionRate->status === 'active') {
            $commissionAmount = $amount * ($commissionRate->amount / 100);
            $finalAmount -= $commissionAmount;
        }

        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        if ($user->balance < $finalAmount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();
        }

        BankTransfer::create([
            'user_id' => $user->id,
            'bank_name' => $name,
            'ac_name' => $request->ac_name,
            'ac_number' => $request->ac_number,
            'district_name' => $request->district_name,
            'reference' => $request->reference,
            'amount' => $request->amount,
            'commission' => $commissionAmount,
            'fee' => $chargeAmount,
        ]);

        $user->balance -= $finalAmount;
        $user->update();

        $notification = new FcmController();
        $notification->sendAdminNotification("Bank Transfer request", $request->get('bank_name') . ' transfer request from ' . $user->name);

        $notification = [
            'message' => $request->bank_name . ' রিকোয়েস্ট সফলভাবে পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function mBankingProceed(Request $request, $name)
    {
        $amount = $request->amount;
        $finalAmount = $amount;
        $chargeAmount = 0;
        $commissionAmount = 0;

        if ($request->type === 'Agent Number') {
            $cashoutCharge = Commission::findOrFail(10);
            $commissionRate = Commission::findOrFail(4);

            if ($cashoutCharge->status === 'active') {
                $chargeAmount = $amount * ($cashoutCharge->amount / 100);
                $finalAmount += $chargeAmount;  // Add charge to the final amount
            }

            if ($commissionRate->status === 'active') {
                $commissionAmount = $amount * ($commissionRate->amount / 100);
                $finalAmount -= $commissionAmount;
            }

        } elseif ($request->type === 'Personal Number') {
            $sendMoneyCharge = Commission::findOrFail(8);
            $commissionRate = Commission::findOrFail(4);

            if ($sendMoneyCharge->status === 'active') {
                $chargeAmount = $sendMoneyCharge->amount;
                $finalAmount += $chargeAmount;
            }

            if ($commissionRate->status === 'active') {
                $commissionAmount = $amount * ($commissionRate->amount / 100);
                $finalAmount -= $commissionAmount;
            }
        }

        $user = Auth::user();
        if ($user->pin != $request->pin) {
            return back()->withErrors(['pin' => 'আপনার পিনটি সঠিক নয়।'])->withInput();
        }

        if ($user->balance < $finalAmount) {
            return back()->withErrors(['amount' => 'আপনার একাউন্ট এ পর্যাপ্ত পরিমানে টাকা নেই।'])->withInput();
        }

        // Create the mobile banking order with calculated values
        MBankingOrder::create([
            'user_id' => $user->id,
            'mbank_name' => $name,
            'mbank_number' => $request->number,
            'amount' => $amount,
            'transaction_type' => $request->type,
            'commission' => $commissionAmount,
            'fee' => $chargeAmount,
        ]);

        // Deduct the final amount from the user's balance
        $user->balance -= $finalAmount;
        $user->update();

        // Send notification to admin about the mobile banking request
        $notification = new FcmController();
        $notification->sendAdminNotification(
            "Mobile Banking request",
            $request->get('mbank_name') . ' request from ' . $user->name
        );

        $notification = [
            'message' => $request->mbank_name . ' রিকোয়েস্ট সফলভাবে পাঠানো হয়েছে।',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    public function history(Request $request)
    {
        $settings = Settings::first();
        $user = Auth::user();
        $userId = $user->id;

        $perPage = 10;
        $page = $request->get('page', 1);

        $histories = collect();

        // Add Money History
        $histories = $histories->merge(
            AddMoneyOrder::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Add Money',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Method: ' . $item->method_name . ', Account: ' . $item->account_number,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Recharge History
        $histories = $histories->merge(
            Recharge::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Recharge',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Operator: ' . $item->operator_name . ', Number: ' . $item->number,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Remittance History
        $histories = $histories->merge(
            RemittanceOrder::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Remittance',
                    'amount' => $item->transfer_amount,
                    'status' => $item->status,
                    'details' => 'Recipient: ' . $item->recipient_name . ', Bank: ' . $item->bank_name,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Send Money History
        $histories = $histories->merge(
            SendmoneyOrder::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Send Money',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Recipient Number: ' . $item->ac_number,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Bill Payment History
        $histories = $histories->merge(
            BillPayment::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Bill Payment',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Bill: ' . $item->billing_name . ', Account: ' . $item->account_number,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Bank Transfer History
        $histories = $histories->merge(
            BankTransfer::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Bank Transfer',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Bank: ' . $item->bank_name . ', A/C Name: ' . $item->ac_name,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Mobile Banking History
        $histories = $histories->merge(
            MBankingOrder::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Mobile Banking',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'MBanking: ' . $item->mbank_name . ', Number: ' . $item->mbank_number,
                    'created_at' => $item->created_at
                ];
            })
        );

        $histories = $histories->merge(
            DriveOrder::where('user_id', $userId)->get()->map(function ($item) {
                return [
                    'type' => 'Package Order',
                    'amount' => $item->amount,
                    'status' => $item->status,
                    'details' => 'Offer: ' . $item->packageInfo->name . ', Number: ' . $item->number . ' Type: ' . $item->type,
                    'created_at' => $item->created_at
                ];
            })
        );

        // Sort & paginate
        $perPage = 10;
        $currentPage = request()->get('page', 1);
        $paginated = new \Illuminate\Pagination\LengthAwarePaginator(
            $histories->forPage($currentPage, $perPage),
            $histories->count(),
            $perPage,
            $currentPage,
            ['path' => request()->url(), 'query' => request()->query()]
        );

        Log::info("History", [$paginated]);
        return view('frontend.dashboard.pages.history', compact('paginated', 'settings', 'user'));
    }

    public function profileIndex(): View
    {
        $settings = Settings::first();
        $user = Auth::user();
        return view('frontend.dashboard.pages.profile', compact('settings', 'user'));
    }

    public function updateProfile(Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'number' => 'required|max:255|unique:users,phone,' . auth()->id(),
            'profile' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ], [

            'name.required' => 'Name is required',
            'name.max' => 'Name cannot be longer than 255 characters',
            'phone.required' => 'Phone is required',
            'phone.max' => 'Phone cannot be longer than 255 characters',
            'phone.unique' => 'Phone is already taken',
            'profile.image' => 'Image must be a image',
            'profile.mimes' => 'Image must be a file of type: jpeg, png, jpg',
            'profile.max' => 'Image must be less than 2MB',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $update = User::findOrFail(auth()->id());
        $update->name = $request->name;
        $update->phone = $request->number;

        if ($request->hasFile('profile')) {
            if ($update->profile && File::exists(public_path($update->profile))) {
                File::delete(public_path($update->profile));
            }
            $update->profile = $this->processImage($request->file('profile'), 'profile');
        }

        $update->update();

        $notification = [
            'message' => 'প্রোফাইল সফলভাবে আপডেট করা হয়েছে',
            'alert-type' => 'success'
        ];

        return redirect()->back()->with($notification);
    }

    private function processImage($file, $fieldName): string
    {
        $fileName = time() . '_' . $fieldName . '.' . $file->getClientOriginalExtension();
        $path = 'upload/users/' . $fileName;
        $file->move(public_path('upload/users/'), $fileName);
        return $path;
    }

    public function updatePassword(Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'old_password' => 'required',
            'new_password' => 'required|string|min:6',
            'confirm_password' => 'required|string|min:6|same:new_password',
        ], [
            'old_password.required' => 'পুরাতন পাসওয়ার্ড প্রদান করুন।',
            'new_password.required' => 'নতুন পাসওয়ার্ড প্রদান করুন।',
            'new_password.min' => 'নতুন পাসওয়ার্ড অবশ্যই কমপক্ষে ৬ অক্ষরের হতে হবে।',
            'confirm_password.required' => 'পাসওয়ার্ড নিশ্চিত করুন।',
            'confirm_password.min' => 'নিশ্চিতকরণ পাসওয়ার্ড অবশ্যই কমপক্ষে ৬ অক্ষরের হতে হবে।',
            'confirm_password.same' => 'নিশ্চিতকরণ পাসওয়ার্ডটি নতুন পাসওয়ার্ডের সাথে মেলে না।',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

        if (!Hash::check($request->old_password, auth::user()->password)) {
            return redirect()->back()->withErrors(['old_password' => 'পুরোনো পাসওয়ার্ড ভুল দিয়েছেন']);
        }

        $updatePass = User::findOrFail(auth()->id());
        $updatePass->password = Hash::make($request->confirm_password);
        $updatePass->update();

        $notification = [
            'message' => 'পাসওয়ার্ড সফলভাবে পরিবর্তন করা হয়েছে',
            'alert-type' => 'success',
        ];
        return redirect()->back()->with($notification);
    }

    public function updatePin(Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'old_pin' => 'required|digits:4',
            'new_pin' => 'required|digits:4',
            'confirm_pin' => 'required|digits:4|same:new_pin',
        ], [
            'old_pin.required' => 'পুরাতন পিন প্রদান করুন।',
            'old_pin.digits' => 'পুরাতন পিন অবশ্যই ৪ সংখ্যার হতে হবে।',
            'new_pin.required' => 'নতুন পিন প্রদান করুন।',
            'new_pin.digits' => 'নতুন পিন অবশ্যই ৪ সংখ্যার হতে হবে।',
            'confirm_pin.required' => 'পিন নিশ্চিত করুন।',
            'confirm_pin.digits' => 'নিশ্চিতকরণ পিন অবশ্যই ৪ সংখ্যার হতে হবে।',
            'confirm_pin.same' => 'নিশ্চিতকরণ পিন নতুন পিনের সাথে মেলে না।',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

        if ($request->old_pin !== auth()->user()->pin) {
            return redirect()->back()->withErrors(['old_pin' => 'পুরাতন পিন ভুল দিয়েছেন।']);
        }

        $user = User::findOrFail(auth()->id());
        $user->pin = $request->confirm_pin;
        $user->update();

        $notification = [
            'message' => 'পিন সফলভাবে পরিবর্তন করা হয়েছে।',
            'alert-type' => 'success',
        ];

        return redirect()->back()->with($notification);
    }

    public function packageIndex($package)
{
    $settings = Settings::first();
    $user = Auth::user();
    $operators = Package::getOperators();

    $items = Package::where('package', $package)
                    ->where('status', 'active') // Only active packages
                    ->orderBy('id', 'desc')
                    ->get();

    return view('frontend.dashboard.pages.items', compact('settings', 'user', 'operators', 'items'));
}
public function packageDetails($operator, $order_id)
{
    $settings = Settings::first();
    $user = Auth::user();
    $operator = strtolower($operator);

    $item = Package::where('operator', $operator)
                   ->where('status', 'active') // Only active item
                   ->findOrFail($order_id);

    return view('frontend.dashboard.pages.details', compact('settings', 'user', 'item', 'operator'));
}


    public function placeOrder(Request $request, $item_id)
    {
        $request->validate([
            'number' => 'required|numeric',
            'pin' => 'required|numeric',
        ]);

        $user = auth()->user();

        $package = Package::findOrFail($item_id);

        $amount = (float)$package->selling_price;

        $commissionRate = Commission::findOrFail(3);
        $calculate = 0;
        $finalAmount = $amount;

        if ($commissionRate->status === 'active') {
            $calculate = $amount * ((float)$commissionRate->amount / 100);
            $finalAmount = $amount - $calculate;
        }

        if ((float)$user->balance < $finalAmount) {
            return redirect()->back()->with([
                'message' => 'আপনার একাউন্টে পর্যাপ্ত পরিমাণ টাকা নেই।',
                'alert-type' => 'warning',
            ])->withInput();
        }

        if ($user->pin !== $request->pin) {
            return redirect()->back()->withErrors([
                'pin' => 'আপনি ভুল পিন দিয়েছেন।',
            ])->withInput();
        }

        DriveOrder::create([
            'user_id' => $user->id,
            'package_id' => $package->id,
            'price' => $package->selling_price,
            'discount' => $package->discount_price,
            'number' => $request->number,
            'pay' => $finalAmount,
            'type' => $package->package,
            'commission' => $calculate,
        ]);

        $user->balance -= $finalAmount;
        $user->save();

        $notification = new FcmController();
        $notification->sendAdminNotification("Drive Purchase", $package->name . ' is purchased from ' . $user->name);

        return redirect()->back()->with([
            'message' => 'আপনার অর্ডারটি সফলভাবে সম্পন্ন হয়েছে।',
            'alert-type' => 'success',
        ]);
    }


}
