<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

class CheckInstallation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the application is installed
        if (config('app.installed', 0) == 0) {
            // If not installed, redirect to the installer page
            if (!$this->isInstallerRoute($request)) {
                return redirect()->route('installer.requirements');
            }
        } else {
            // If installed, prevent access to installer routes and redirect to login or home page
            if ($this->isInstallerRoute($request)) {
                return redirect()->route('login'); // You can change 'login' to 'welcome' if needed
            }
        }

        return $next($request);
    }

    /**
     * Check if the current route is part of the installer.
     */
    protected function isInstallerRoute(Request $request): bool
    {
        $installerRoutes = [
            'installer.requirements',
            'installer.update-requirements',
            'installer.database',
            'installer.install',
            'installer.import',
            'installer.db-download',
            'installer.db-import',
            'installer.skip',
            'installer.finished',
            'installer.installation-finished',
        ];

        // Get the current route name
        $currentRouteName = Route::currentRouteName();

        return in_array($currentRouteName, $installerRoutes);
    }
}
