<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create(array $array)
 * @method static where(string $string, int|string|null $id)
 * @method static findOrFail($id)
 */
class AddMoneyOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'method_name',
        'holder_name',
        'account_number',
        'amount',
        'sent_date',
        'note',
        'trx_id',
        'screenshot',
        'add_money',
        'status',
        'reason',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }
}
