<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create(array $array)
 * @method static where(string $string, int|string|null $id)
 */
class BillPayment extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'billing_name',
        'account_number',
        'billing_date',
        'customer_name',
        'customer_number',
        'amount',
        'status',
        'reason',
        'commission',
        'fee',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }
}
