<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static findOrFail(mixed $get)
 * @method static create(array $array)
 * @method static where(string $string, int|string|null $id)
 */
class DriveOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'package_id', 'price', 'discount', 'number', 'type', 'status', 'reason', 'pay', 'commission'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }

    public function packageInfo(): BelongsTo
    {
        return $this->belongsTo(Package::class, 'package_id'); // 'user_id' is the foreign key
    }
}
