<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create(array $array)
 * @method static where(string $string, int|string|null $id)
 * @method static findOrFail(mixed $recharge_id)
 */
class GlobalRechargeOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'number',
        'operator',
        'amount',
        'status',
        'reason',
        'commission'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
