<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static where(string $string, $id)
 */
class Installment extends Model
{
    use HasFactory;

    protected $fillable = [
        'loan_application_id',
        'per_installment',
        'installment_id',
        'due_date',
        'status',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }

    public function loan(): BelongsTo
    {
        return $this->belongsTo(LoanApplications::class, 'loan_application_id');
    }
}
