<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create(array $array)
 * @method static where(string $string, int|string|null $id)
 */
class LoanApplications extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'application_date',
        'amount',
        'installments',
        'total_amount',
        'interest_rate',
        'per_installment',
        'paid_installment',
        'status',
        'reason',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }
}
