<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @method static where(string $string, $slug)
 * @method static findOrFail($id)
 * @method static orderBy(string $string, string $string1)
 */
class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'buying_price',
        'selling_price',
        'discount_price',
        'operator',
        'package',
        'validity'
    ];

    public const OPERATORS = [
        'grameenphone' => 'Grameenphone',
        'skitto' => 'Skitto',
        'robi' => 'Robi',
        'airtel' => 'Airtel',
        'banglalink' => 'Banglalink',
        'teletalk' => 'Teletalk',
    ];

    public static function getOperators(): array
    {
        return self::OPERATORS;
    }
}
