<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

/**
 * @method static where(string $string, string $string1)
 * @method static findOrFail(int|string|null $id)
 * @method static create(array $array)
 * @method static whereNotNull(string $string)
 * @method static whereHas(string $string, \Closure $param)
 */
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name', 'email', 'username', 'balance', 'phone', 'location',
        'profile', 'fcm_token', 'pin', 'accountID', 'loan_amount',
        'permissions', 'device', 'role', 'status', 'password',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function chats(): HasMany
    {
        return $this->hasMany(Chat::class, 'sender_id');
    }


    public function document(): HasOne
    {
        return $this->hasOne(UserDocument::class, 'user_id');
    }

}
