<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static findOrFail(int|string|null $id)
 */
class UserDocument extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'type', 'document_one', 'document_two', 'status'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id'); // 'user_id' is the foreign key
    }
}
