<?php

namespace App\Observers;

use App\Models\UserDocument;

class UserDocumentObserver
{
    /**
     * Handle the UserDocument "created" event.
     */
    public function created(UserDocument $document): void
    {
        if ($document->status === 'Pending') {
            $user = $document->user;
            $message = "KYC pending for user: {$user->name} (Email: {$user->email})";

            $notification = new \App\Http\Controllers\FcmController();
            $notification->sendAdminNotification("KYC Pending", $message);
        }
    }

    /**
     * Handle the UserDocument "updated" event.
     */
    public function updated(UserDocument $userDocument): void
    {
        //
    }

    /**
     * Handle the UserDocument "deleted" event.
     */
    public function deleted(UserDocument $userDocument): void
    {
        //
    }

    /**
     * Handle the UserDocument "restored" event.
     */
    public function restored(UserDocument $userDocument): void
    {
        //
    }

    /**
     * Handle the UserDocument "force deleted" event.
     */
    public function forceDeleted(UserDocument $userDocument): void
    {
        //
    }
}
