<?php

namespace App\Services;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;


class EncryptionService
{
    private static $ALGORITHM = 'aes-256-cbc';

    /**
     * @throws RandomException
     */
    public static function generateKey($seed, $keyLength): string
    {
        // Generate a SHA-256 hash of the seed
        $randomSeed = $seed . random_bytes(16);  // Add randomness to the seed
        $hash = hash('sha256', $randomSeed, true);
        // Encode the hash in base64 and truncate it to the desired length
        return substr(base64_encode($hash), 0, $keyLength / 8);
    }

    public static function encrypt($data, $secretKey): string
    {
        // Generate an initialization vector
        $ivLength = openssl_cipher_iv_length(self::$ALGORITHM);
        $iv = openssl_random_pseudo_bytes($ivLength);

        // Encrypt the data
        $encrypted = openssl_encrypt($data, self::$ALGORITHM, $secretKey, OPENSSL_RAW_DATA, $iv);

        // Combine IV and encrypted data for storage/transmission
        return base64_encode($iv . $encrypted);
    }

}
