<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('username')->unique()->nullable();
            $table->string('email')->unique()->nullable();
            $table->double('balance')->default(0);
            $table->bigInteger('loan_amount')->default(0);
            $table->string('phone')->unique()->nullable();
            $table->string('location')->nullable(); // Keep this one
            $table->string('logged_in_location')->nullable(); // Keep this one
            $table->string('profile')->nullable();
            $table->string('fcm_token')->nullable();
            $table->string('pin')->nullable();
            $table->string('accountID')->nullable();
            $table->json('permissions')->nullable();
            $table->string('device')->nullable();
            $table->enum('role', ['admin', 'user', 'subAdmin', 'dgm', 'dealer', 'retailer', 'manager'])->default('retailer');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
