<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bank_gateways', function (Blueprint $table) {
            $table->id();
            $table->string('bank_name');
            $table->string('slug')->unique();
            $table->string('ac_holder_name');
            $table->string('ac_holder_number');
            $table->string('ibn_no');
            $table->string('branch_name');
            $table->string('country_name');
            $table->integer('min_amount')->nullable();
            $table->integer('max_amount')->nullable();
            $table->string('logo');
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bank_gateways');
    }
};
