<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('remittance_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('recipient_number');
            $table->string('recipient_name');
            $table->string('bank_name');
            $table->string('transfer_amount');
            $table->string('sender_number');
            $table->string('sender_name');
            $table->enum('status', ['pending', 'accepted', 'cancelled'])->default('pending');
            $table->string('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('remittance_orders');
    }
};
