<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('m_banking_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('mbank_name');
            $table->string('mbank_number');
            $table->integer('amount');
            $table->string('transaction_type');
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->string('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('m_banking_orders');
    }
};
