<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('add_money_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('method_name')->nullable();
            $table->string('holder_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('amount')->nullable();
            $table->string('sent_date')->nullable();
            $table->string('note')->nullable();
            $table->string('trx_id')->nullable();
            $table->string('screenshots')->nullable();
            $table->enum('add_money', ['AUTO', 'MobileBanking', 'Bank']);
            $table->enum('status', ['success', 'pending', 'failed', 'cancelled'])->default('pending');
            $table->string('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('add_money_orders');
    }
};
