<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('header_sections', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('short_title')->nullable();
            $table->text('short_description')->nullable();
            $table->string('h_screenshot')->nullable();
            $table->string('h_bg_image')->nullable();
            $table->string('logo')->nullable();
            $table->string('total_clients')->nullable();
            $table->string('total_download')->nullable();
            $table->string('total_rates')->nullable();
            $table->string('total_awards')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('header_sections');
    }
};
