<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <title>Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- favicon -->
    <link rel="shortcut icon" href="{{ $settings->brandLogo }}">
    <!-- Bootstrap -->
    <link href="{{ asset('u_dash/assets/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- simplebar -->
    <link href="{{ asset('u_dash/assets/css/simplebar.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Icons -->
    <link href="{{ asset('u_dash/assets/css/materialdesignicons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('u_dash/assets/css/tabler-icons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="https://unicons.iconscout.com/release/v3.0.6/css/line.css" rel="stylesheet">
    <!-- Css -->
    <link href="{{ asset('u_dash/assets/css/style.css')}}" rel="stylesheet" type="text/css" id="theme-opt"/>

</head>

<body>
<!-- Loader -->
<div id="preloader">
    <div id="status">
        <div class="spinner">
            <div class="double-bounce1"></div>
            <div class="double-bounce2"></div>
        </div>
    </div>
</div>
<!-- Loader -->

<!-- Hero Start -->
<section class="bg-home bg-circle-gradiant d-flex align-items-center">
    <div class="bg-overlay bg-overlay-white"></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="form-signin p-4 bg-white rounded shadow">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf
                        <a href="{{ route('index') }}"><img src="{{ $settings->brandLogo }}"
                                                            class="avatar mb-4 d-block mx-auto" alt=""
                                                            style="height: 24px; width: 15vh;"></a>
                        <h5 class="mb-3 text-center">Please sign in</h5>

                        <div class="form-floating mb-2">
                            <input type="text" class="form-control" id="floatingInput" placeholder="Email or Phone"
                                   name="credential">
                            <label for="floatingInput">Email or Phone</label>
                            @error('credential')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="floatingPassword" placeholder="Password"
                                   name="password">
                            <label for="floatingPassword">Password</label>
                            @error('password')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-between">
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">Remember me</label>
                                </div>
                            </div>

                            <p class="forgot-pass mb-0"><a href="{{ route('forgot') }}" class="text-dark small fw-bold">Forgot password ?</a></p>

                        </div>

                        <button class="btn btn-primary w-100" type="submit">Sign in</button>

                        <div class="col-12 text-center mt-3">
                            <p class="mb-0 mt-3"><small class="text-dark me-2">Don't have an account ?</small> <a
                                    href="{{ route('register') }}" class="text-dark fw-bold">Sign Up</a></p>
                        </div><!--end col-->

                        <p class="mb-0 text-muted mt-3 text-center">©
                            <script>document.write(new Date().getFullYear())</script>
                            {{ $settings->brandName }}
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div> <!--end container-->
</section><!--end section-->
<!-- Hero End -->

<!-- javascript -->
<script src="{{ asset('u_dash/assets/js/bootstrap.bundle.min.js')}}"></script>
<!-- simplebar -->
<script src="{{ asset('u_dash/assets/js/simplebar.min.js')}}"></script>
<!-- Icons -->
<script src="{{ asset('u_dash/assets/js/feather.min.js')}}"></script>
<!-- Main Js -->
<script src="{{ asset('u_dash/assets/js/plugins.init.js')}}"></script>
<script src="{{ asset('u_dash/assets/js/app.js')}}"></script>
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Check if Ctrl is held down and keycode is not in the allowed list
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    // Fix for Ctrl+V not working in input elements
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Allow Ctrl+V specifically in input and textarea
        if (event.ctrlKey && event.keyCode === 86 && (event.target.tagName === "INPUT" || event.target.tagName === "TEXTAREA")) {
            return true;  // Allow Ctrl+V in input or textarea
        }

        // Block other Ctrl key combinations
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

</script>
</body>

</html>
