<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <title>Register</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- favicon -->
    <link rel="shortcut icon" href="{{ $settings->brandLogo }}">
    <!-- Bootstrap -->
    <link href="{{ asset('u_dash/assets/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- simplebar -->
    <link href="{{ asset('u_dash/assets/css/simplebar.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Icons -->
    <link href="{{ asset('u_dash/assets/css/materialdesignicons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('u_dash/assets/css/tabler-icons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="https://unicons.iconscout.com/release/v3.0.6/css/line.css" rel="stylesheet">
    <!-- Css -->
    <link href="{{ asset('u_dash/assets/css/style.css')}}" rel="stylesheet" type="text/css" id="theme-opt"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

</head>

<body>
<!-- Loader -->
<div id="preloader">
    <div id="status">
        <div class="spinner">
            <div class="double-bounce1"></div>
            <div class="double-bounce2"></div>
        </div>
    </div>
</div>
<!-- Loader -->

<!-- Hero Start -->
<section class="bg-home bg-circle-gradiant d-flex align-items-center">
    <div class="bg-overlay bg-overlay-white"></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="form-signin p-4 bg-white rounded shadow">
                    <form method="POST" action="{{ route('register') }}" enctype="multipart/form-data">
                        @csrf
                    <a href="{{ route('index') }}"><img src="{{ $settings->brandLogo }}"
                                                            class="avatar mb-4 d-block mx-auto" alt=""
                                                            style="height: 24px; width: 15vh;"></a>
                        <h5 class="mb-3 text-center">নতুন একাউন্ট তৈরি করুন</h5>

                        <div class="form-floating mb-2">
                            <input type="text" class="form-control" id="floatingInput" placeholder="Harry" name="name" value="{{ old('name') }}">
                            <label for="floatingInput">নাম লিখুন</label>
                            @error('name')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-floating mb-2">
                            <input type="email" class="form-control" id="floatingEmail" placeholder="name@example.com" value="{{ old('email') }}"
                                   name="email">
                            <label for="floatingEmail">ইমেইল আইডি লিখুন</label>
                            @error('email')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-floating mb-2">
                            <input type="number" class="form-control" id="floatingEmail" placeholder="name@example.com" value="{{ old('phone') }}"
                                   name="phone">
                            <label for="floatingEmail">ফোন নাম্বার</label>
                            @error('phone')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-2">
                            <label for="state" class="form-label">ডকুমেন্ট আপলোড করুন</label>
                            <select class="form-select form-control" id="documentType" name="document" required>
                                <option selected disabled>বাছাই করুন...</option>
                                <option value="Driving Document">ড্রাইভিং লাইসেন্স</option>
                                <option value="Birth Certificate Document">জম্ন নিবন্ধন</option>
                                <option value="Nid Card Document">এনআইডি</option>
                            </select>
                            <div class="invalid-feedback">
                                একটি সঠিক ডকুমেন্ট নির্বাচন করুন।
                            </div>
                            @error('document')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-2" id="front-part">
                            <label for="frontImage">উপরের অংশ</label>
                            <input type="file" class="form-control" id="frontImage" name="front_img">
                            @error('front_img')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-2" id="back-part">
                            <label for="backImage">নিচের অংশ</label>
                            <input type="file" class="form-control" id="backImage" name="back_img">
                            @error('back_img')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-floating mb-3">
                            <input type="number" class="form-control" id="floatingPassword" placeholder="পিন লিখুন" name="pin" maxlength="6" value="{{ old('pin') }}">
                            <label for="floatingPassword">পিন লিখুন</label>
                            @error('pin')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="floatingPassword" placeholder="Password" name="password" value="{{ old('password') }}">
                            <label for="floatingPassword">পাসওয়ার্ড লিখুন</label>
                            @error('password')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <button class="btn btn-primary w-100" type="submit">রেজিস্টার</button>

                        <div class="col-12 text-center mt-3">
                            <p class="mb-0 mt-3"><small class="text-dark me-2">ইতোমধ্যে একটি একাউন্ট আছে?</small> <a
                                    href="{{ route('login') }}" class="text-dark fw-bold">লগইন</a></p>
                        </div>

                        <p class="mb-0 text-muted mt-3 text-center">©
                            <script>document.write(new Date().getFullYear())</script>
                            Landrick.
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div> <!--end container-->
</section><!--end section-->
<!-- Hero End -->

<!-- javascript -->
<script src="{{ asset('u_dash/assets/js/bootstrap.bundle.min.js')}}"></script>
<!-- simplebar -->
<script src="{{ asset('u_dash/assets/js/simplebar.min.js')}}"></script>
<!-- Icons -->
<script src="{{ asset('u_dash/assets/js/feather.min.js')}}"></script>
<!-- Main Js -->
<script src="{{ asset('u_dash/assets/js/plugins.init.js')}}"></script>
<script src="{{ asset('u_dash/assets/js/app.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
@if (Session::has('message'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const message = "{{ Session::get('message') }}";
            const type = "{{ Session::get('alert-type', 'info') }}"; // Use 'info' as default type

            let toastOptions = {
                text: message,
                duration: 3000, // Duration in milliseconds
                gravity: "top", // 'top' or 'bottom'
                position: 'right', // 'left' or 'right'
                stopOnFocus: true // Prevent toast from hiding on hover
            };

            // Customize options based on the message type
            switch (type) {
                case 'success':
                    toastOptions.backgroundColor = "#28a745"; // Solid green for success
                    break;
                case 'error':
                    toastOptions.backgroundColor = "#dc3545"; // Solid red for error
                    break;
                case 'warning':
                    toastOptions.backgroundColor = "#ffc107"; // Solid yellow for warning
                    break;
                default:
                    toastOptions.backgroundColor = "#6c757d"; // Default solid color (gray)
            }

            Toastify(toastOptions).showToast();
        });
    </script>
@endif
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Check if Ctrl is held down and keycode is not in the allowed list
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    // Fix for Ctrl+V not working in input elements
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Allow Ctrl+V specifically in input and textarea
        if (event.ctrlKey && event.keyCode === 86 && (event.target.tagName === "INPUT" || event.target.tagName === "TEXTAREA")) {
            return true;  // Allow Ctrl+V in input or textarea
        }

        // Block other Ctrl key combinations
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    document.addEventListener("DOMContentLoaded", function () {
        const docSelect = document.getElementById("documentType");
        const frontPart = document.getElementById("front-part");
        const backPart = document.getElementById("back-part");

        frontPart.style.display = "none";
        backPart.style.display = "none";

        docSelect.addEventListener("change", function () {
            const selected = this.value;

            if (selected === "Birth Certificate Document") {
                frontPart.style.display = "block";
                backPart.style.display = "none";
            } else if (selected === "Driving Document" || selected === "Nid Card Document") {
                frontPart.style.display = "block";
                backPart.style.display = "block";
            } else {
                frontPart.style.display = "none";
                backPart.style.display = "none";
            }
        });
    });

</script>
</body>

</html>
