@extends('main')
@section('h_title', 'All Banks')
@section('banking_main', 'active')
@section('banking_main_expand', 'true')
@section('banking_show_main', 'show')
@section('bank_main', 'active')
@section('bank_show', 'show')
@section('bank_view', 'active')
@push('css_cdn')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
@endpush
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Banks</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
                                </div>
                            </th>
                            <th data-ordering="false">SR No.</th>
                            <th data-ordering="false">Logo</th>
                            <th data-ordering="false">Name</th>
                            <th data-ordering="false">Slug</th>
                            <th data-ordering="false">Status</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($bank_data as $data)
                            <tr>
                                <th scope="row">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="checkAll"
                                               value="option1">
                                    </div>
                                </th>
                                <td>{{ $loop->iteration }}</td>
                                <td><img src="{{ asset($data->logo) }}" alt="{{ $data->name }}"
                                         style="height: 50px; width: 50px;"></td>
                                <td>{{ $data->name }}</td>
                                <td>{{ $data->slug }}</td>
                                <td>
                                    <button style="width: 50px;"
                                            class="btn btn-{{ $data->status == 1 ? 'primary' : 'danger' }} waves-effect waves-light btn-sm">{{ $data->status == 1 ? 'On' : 'Off' }}</button>

                                </td>
                                <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                <td>
                                    <a href="{{ route('admin.banking.edit', $data->id) }}"
                                       class="btn btn-outline-primary btn-icon waves-effect waves-light"><i
                                            class="ri-edit-box-line"></i></a>
                                    <a href="{{ route('admin.banking.item.delete', $data->id) }}"
                                       class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn" onclick="return confirmDelete(this);" ><i
                                            class="ri-delete-bin-line"></i></a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div><!--end col-->
    </div><!--end row-->

@endsection
@push('js_cdn')

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>
        function confirmDelete(element) {
            // Display the confirmation dialog
            if (confirm('Are you sure you want to delete this? This action cannot be undone.')) {
                // If confirmed, redirect to the deletion URL
                window.location.href = element.href;
                return true; // Allow the browser to follow the link
            } else {
                // If cancelled, do nothing
                return false; // Prevent the browser from following the link
            }
        }
    </script>
@endpush

