@extends('main')
@section('h_title', 'Bill Orders')
@section('bill_view', 'active')
@section('bill_main', 'active')
@section('bill_show', 'show')
@section('bill_expanded', 'true')
@push('css_cdn')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
@endpush
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Bill Orders</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll"
                                           value="option">
                                </div>
                            </th>
                            <th data-ordering="false">#</th>
                            <th data-ordering="false">Name</th>
                            <th data-ordering="false">Billing Name</th>
                            <th data-ordering="false">Customer Name</th>
                            <th data-ordering="false">A/C Number</th>
                            <th data-ordering="false">Billing Date</th>
                            <th data-ordering="false">Customer Number</th>
                            <th data-ordering="false">Amount</th>
                            <th data-ordering="false">Status</th>
                            <th data-ordering="false">Reason</th>
                            <th>Order Date</th>
                            <th>Action</th>

                        </tr>
                        </thead>
                        <tbody>
                        @foreach($items as $data)
                            <tr>
                                <th scope="row">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="checkAll"
                                               value="option1">
                                    </div>
                                </th>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <span
                                        class="{{ $data->user == null ? 'text-danger':'text-dark' }}">{{ $data->user == null ? 'User Not found':$data->user->name }}</span>
                                </td>
                                <td>
                                    {{ $data->billing_name }}
                                </td>
                                <td>{{ $data->customer_name }} </td>
                                <td>{{ $data->account_number }} </td>
                                <td>{{ $data->billing_date }} </td>
                                <td>{{ $data->customer_number }} </td>
                                <td>{{ $data->amount }} BDT
                                    <br> <small
                                        class="text-danger mt-2 mt-2">{{ $data->commission != null ? $data->commission . __(' BDT Commission') : '' }}</small>
                                    <br>
                                    <small
                                        class="text-danger mt-2 mt-2">{{ $data->fee != null ? $data->fee . __(' BDT Fee') : '' }}</small>
                                </td>
                                <td>
                                    <button
                                        class="btn btn-{{ $data->status == 'pending' ? 'warning' : ($data->status == 'approved' ? 'success' : 'danger') }} waves-effect waves-light btn-sm">{{ $data->status == 'pending' ? 'Pending' : ($data->status == 'approved' ? 'Accepted' : 'Cancelled') }}</button>

                                </td>
                                <td class="text-danger">{{ $data->reason == null ? 'N/A' : $data->reason}}</td>
                                <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                <td>
                                    @if($data->status === 'pending')
                                        <!-- Success Button -->
                                        <button
                                            class="btn btn-success waves-effect waves-light success-btn"
                                            data-bs-toggle="modal" data-bs-target="#statusModal"
                                            data-id="{{ $data->id }}"
                                            data-name="{{ $data->billing_name }}"
                                            data-account="{{ $data->account_number }}"
                                            data-customerNumber="{{ $data->customer_number }}"
                                            data-customerName="{{ $data->customer_name }}"
                                            data-amount="{{ $data->amount }}"
                                            data-date="{{ $data->billing_date }}"
                                        >
                                            <i class="ri-checkbox-circle-line"></i> Success
                                        </button>

                                        <!-- Reject Button -->
                                        <button
                                            class="btn btn-primary waves-effect waves-light reject-btn"
                                            data-bs-toggle="modal" data-bs-target="#rejectModal"
                                            data-id="{{ $data->id }}">
                                            <i class="ri-close-circle-line"></i> Reject
                                        </button>

                                        <!-- Delete Button -->
                                        <a href="{{ route('admin.bill.delete', $data->id) }}"
                                           onclick="return confirmRechargeDelete(this);" data-bs-toggle="tooltip"
                                           data-bs-placement="top" data-bs-title="Delete"
                                           class="btn btn-outline-danger waves-effect waves-light remove-item-btn">
                                            <i class="ri-delete-bin-line"></i> Delete
                                        </a>
                                    @elseif($data->status === 'approved' || $data->status === 'rejected')
                                        <!-- Only Delete Button for Success or Rejected Status -->
                                        <a href="{{ route('admin.bill.delete', $data->id) }}"
                                           onclick="return confirmRechargeDelete(this);" data-bs-toggle="tooltip"
                                           data-bs-placement="top" data-bs-title="Delete"
                                           class="btn btn-outline-danger waves-effect waves-light remove-item-btn">
                                            <i class="ri-delete-bin-line"></i> Delete
                                        </a>
                                    @endif

                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div><!--end col-->
    </div><!--end row-->


    <!-- Approved Modal -->
    <div class="modal fade" id="statusModal" data-bs-backdrop="static" data-bs-keyboard="false"
         tabindex="-1" aria-labelledby="statusModal" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('admin.bill.order.approved') }}" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="success_id" id="success_id">
                <div class="modal-content" style="background-color: white;">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editUserModalLabel">Order Confirmation</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label for="package_name" class="form-label label text-secondary">Billing Name</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="name" disabled>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="pay_amount" class="form-label label text-secondary">Customer Name</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="cus_name"
                                           disabled>
                                </div>
                            </div>

                            <div class="col-lg-6 mb-2">
                                <label for="ac_number" class="form-label text-secondary">A/C Number</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="ac_number" disabled>
                                    <button class="btn btn-primary" id="copyAcNumber" type="button">Copy
                                    </button>
                                </div>
                            </div>

                            <div class="col-lg-6 mb-2">
                                <label for="number" class="form-label text-secondary">Customer Number</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="cus_number" disabled>
                                    <button class="btn btn-primary" id="copyNumber" type="button">Copy
                                    </button>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="type"
                                       class="form-label label text-secondary">Date</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="date"
                                           disabled>
                                </div>
                            </div>


                            <div class="col-md-6 mb-2">
                                <label for="type"
                                       class="form-label label text-secondary">Amount</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="amount"
                                           disabled>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="type"
                                       class="form-label label text-secondary"><br></label>
                                <button type="submit" class="btn btn-success fw-medium text-white px-4 w-100">
                                    Approved
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal" data-bs-backdrop="static" data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="rejectModal" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('admin.bill.order.rejected') }}" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="reject_id" id="reject_id">
                <div class="modal-content" style="background-color: white;">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editUserModalLabel">Billing Rejection</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="validationCustom09" class="form-label label text-secondary">Write Reject
                                    Reason :</label>
                                <div class="position-relative">
                                    <textarea cols="10" rows="4" class="form-control" id="validationCustom09"
                                              placeholder="Reason" name="reason" required></textarea>

                                </div>

                                @error('reason')
                                <span class="text-danger m-2">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="validationCustom10"
                                       class="form-label label text-secondary"> <br> </label>
                                <div class="position-relative">
                                    <button type="submit"
                                            class="btn btn-danger fw-medium text-white">
                                        Submit
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection
@push('js_cdn')

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>

        function confirmRechargeDelete(element) {
            // Display the confirmation dialog
            if (confirm('Are you sure you want to delete this Mobile Banking? This action cannot be undone.')) {
                // If confirmed, redirect to the deletion URL
                window.location.href = element.href;
                return true; // Allow the browser to follow the link
            } else {
                // If cancelled, do nothing
                return false; // Prevent the browser from following the link
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            const editButtons = document.querySelectorAll('.success-btn');

            editButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    const name = this.getAttribute('data-name');
                    const account = this.getAttribute('data-account');
                    const amount = this.getAttribute('data-amount');
                    const cus_name = this.getAttribute('data-customerName');
                    const cus_number = this.getAttribute('data-customerNumber');
                    const date = this.getAttribute('data-date');

                    // Populate modal fields with the captured data
                    document.getElementById('success_id').value = id;
                    document.getElementById('name').value = name;
                    document.getElementById('amount').value = amount + " BDT";
                    document.getElementById('cus_name').value = cus_name;
                    document.getElementById('cus_number').value = cus_number;
                    document.getElementById('ac_number').value = account;
                    document.getElementById('date').value = date;
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            const rejectButton = document.querySelectorAll('.reject-btn');

            rejectButton.forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    document.getElementById('reject_id').value = id;
                });
            });
        });

        document.getElementById('copyAcNumber').addEventListener('click', function () {
            copyToClipboard('ac_number');
        });

        document.getElementById('copyNumber').addEventListener('click', function () {
            copyToClipboard('cus_number');
        });

        function copyToClipboard(inputId) {
            // Get the input element by its ID
            const inputElement = document.getElementById(inputId);

            // Temporarily enable the input field to copy its value
            inputElement.disabled = false;
            inputElement.select();

            // Execute the copy command
            document.execCommand('copy');

            // Disable the input field again
            inputElement.disabled = true;

            // Show the alert
            alert('Number copied to clipboard!');
        }


    </script>
@endpush
