@extends('main')
@section('h_title', 'Edit Billing')
@section('bill_view', 'active')
@section('bill_main', 'active')
@section('bill_show', 'show')
@section('bill_expanded', 'true')
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Edit {{ $bill->name }}</h4>
                </div><!-- end card header -->
                <div class="card-body">

                    <form action="{{ route('admin.bill.update', $bill->id) }}" method="POST"
                          enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="col-lg-8">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                               oninput="generateSlug()"
                                               placeholder="Billing Name" value="{{ $bill->name }}">
                                        @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-8">
                                    <div class="mb-3">
                                        <label for="slug" class="form-label">Slug</label>
                                        <input type="text" class="form-control" id="slug" name="slug"
                                               placeholder="auto generated" disabled value="{{ $bill->slug }}">
                                        @error('slug')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-8">
                                    <div class="mb-3">
                                        <label for="type" class="form-label">Name</label>
                                        <input type="text" class="form-control" id="type" name="type"
                                               oninput="generateSlug()"
                                               placeholder="Enter type (exp: Internet, Gas, Biddut etc.)"
                                               value="{{ $bill->type }}">
                                        @error('type')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-8">
                                    <div class="mb-3">
                                        <label for="lastnameInput" class="form-label">Logo</label>
                                        <input class="form-control" type="file" id="logo" name="logo"
                                               onchange="showPreview(event)"/>
                                        @error('logo')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-8">
                                    <div class="form-check form-check-outline form-check-primary mb-3">
                                        <input class="form-check-input" type="checkbox" id="formCheck19" name="status"
                                            {{ $bill->status == 1 ? 'checked' : '' }}>
                                        <label class="form-check-label" for="formCheck19">
                                            Status
                                        </label>
                                    </div>
                                </div>

                                <!--end col-->
                                <div class="col-lg-8">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>

                            <!-- Logo Preview -->
                            <div class="col-lg-6" id="logoPreviewSection">
                                <div class="col-lg-12">
                                    <span class="text-muted col-md-5" style="text-align: center">Logo Preview</span>
                                </div>
                                <div class="col-lg-12">
                                    <img id="logoPreview" height="250" width="250" src="{{ asset($bill->logo) }}"
                                         alt="Logo Preview"/>
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        function generateSlug() {
            const nameInput = document.getElementById('name');
            const slugInput = document.getElementById('slug');

            // Get the value from the name input
            const name = nameInput.value.trim();

            // Generate a slug: convert to lowercase, replace spaces with hyphens, remove non-alphanumeric characters except hyphens
            const slug = name
                .toLowerCase()
                .replace(/\s+/g, '-') // Replace spaces with hyphens
                .replace(/[^\w-]+/g, ''); // Remove non-alphanumeric characters except hyphens

            // Set the slug value to the slug input field
            slugInput.value = slug;
        }

        function showPreview(event) {
            const previewSection = document.getElementById('logoPreviewSection');
            const logoPreview = document.getElementById('logoPreview');
            const file = event.target.files[0];

            if (file) {
                // Show the preview section
                previewSection.style.display = 'block';

                // Create a URL for the selected file and set it as the image source
                const reader = new FileReader();
                reader.onload = function (e) {
                    logoPreview.src = e.target.result;
                }
                reader.readAsDataURL(file);
            } else {
                // Hide the preview section if no file is selected
                previewSection.style.display = 'none';
            }
        }
    </script>
@endpush
