@extends('main')
@section('h_title', 'Commissions')
@section('body')
    <div class="row">
        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Setup Commissions</h5>
                    <hr>

                    @foreach($commissions as $commission)
                        <div class="col-lg-12">
                            <div class="tab-content text-muted mt-3">
                                <div class="tab-pane fade active show" id="custom-v-pills-{{ $commission->id }}"
                                     role="tabpanel"
                                     aria-labelledby="custom-v-pills-{{ $commission->id }}-tab">
                                    <form action="{{ route('admin.commissions.update', $commission->id) }}"
                                          method="POST">
                                        @csrf
                                        @method('PUT')
                                        <div class="row mb-3">
                                            <div class="col-lg-3">
                                                <label for="nameInput{{ $commission->id }}"
                                                       class="form-label">{{ $commission->name }}</label>
                                            </div>
                                            <div class="col-lg-9">
                                                <div class="input-group">
                                                    <input type="text" class="form-control"
                                                           id="nameInput{{ $commission->id }}"
                                                           value="{{ $commission->amount }}"
                                                           name="commission"
                                                           placeholder="Enter commission rate, e.g., 2">
                                                    <span class="input-group-text" id="basic-addon2">%</span>
                                                </div>

                                                <div class="form-check-info mt-3 mb-3">
                                                    <input type="hidden" name="status" value="off">
                                                    <input class="form-check-input" type="checkbox"
                                                           id="formCheck{{ $commission->id }}" name="status"
                                                        {{ $commission->status == 'active' ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="formCheck{{ $commission->id }}">
                                                        {{ $commission->status == 'active' ? 'ON' : 'OFF' }}
                                                    </label>

                                                </div>

                                                <div class="text-start">
                                                    <button type="submit" class="btn btn-sm btn-primary">Update
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @if (!$loop->last)
                            <hr>
                        @endif
                    @endforeach

                </div>
            </div>
        </div>


        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Setup Fees</h5>
                    <hr>
                    @foreach($fees as $fee)

                        <div class="col-lg-12">
                            <div class="tab-content text-muted mt-3">
                                <div class="tab-pane fade active show" id="custom-v-pills-{{ $fee->id }}"
                                     role="tabpanel"
                                     aria-labelledby="custom-v-pills-{{ $fee->id }}-tab">
                                    <form action="{{ route('admin.fees.update', $fee->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')
                                        <div class="row mb-3">
                                            <div class="col-lg-3">
                                                <label for="nameInput{{ $fee->id }}" class="form-label">{{ $fee->name }}
                                                    Fees</label>
                                            </div>
                                            <div class="col-lg-9">
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                           id="nameInput{{ $fee->id }}"
                                                           value="{{ $fee->amount }}"
                                                           name="fee"
                                                           placeholder="{{ getPlaceholderText($fee->name) }}">
                                                    <span class="input-group-text"
                                                          id="basic-addon2">{{ getAttatchedPlaceHolder($fee->name) }}</span>
                                                </div>

                                                <div class="form-check-info mt-3 mb-3">
                                                    <input type="hidden" name="status" value="off">
                                                    <input class="form-check-input" type="checkbox"
                                                           id="formCheck{{ $fee->id }}" name="status"
                                                        {{ $fee->status == 'active' ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                           for="formCheck{{ $fee->id }}">
                                                        {{ $fee->status == 'active' ? 'ON' : 'OFF' }}
                                                    </label>

                                                </div>

                                                <div class="text-start">
                                                    <button type="submit" class="btn btn-sm btn-primary">Update
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        @if(!$loop->last)
                            <hr>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    @php
        function getPlaceholderText($feeName) {
            switch ($feeName) {
                case 'Bank':
                    return 'Enter bank fees rate e.g., 2%';
                case 'Mobile Banking':
                    return 'Enter mobile banking fees amount 10/20 BDT';
                case 'Bill':
                    return 'Enter bill fees amount 10/20 BDT';
                case 'CashOut':
                    return 'Enter all cash out fees rate e.g., 2%';
                case 'Remittance':
                    return 'Enter remittances fees rate e.g., 2%';
                default:
                    return '';
            }
        }

        function getAttatchedPlaceHolder($feeName) {
            switch ($feeName) {
                case 'Remittance':
                case 'CashOut':
                case 'Bank':
                    return '%';
                case 'Bill':
                case 'Mobile Banking':
                    return 'BDT';
                default:
                    return '';
            }
        }
    @endphp
@endsection
