@extends('main')
@section('h_title', 'Support Configure')
@section('support', 'active')
@section('body')

    <div class="row">

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">About Company</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.about-company.update') }}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                <textarea class="ckeditor-classic"
                                                          placeholder="Enter about you or about your company"
                                                          name="about">{{ $company->about_company }}</textarea>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Upload TradeLicense</label>
                                                    <input class="form-control" type="file" name="trade_license"
                                                           id="formFile">
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Upload Certificate</label>
                                                    <input class="form-control" type="file" name="certificate"
                                                           id="formFile">
                                                </div>
                                            </div>
                                            <!--end col-->


                                            <div class="col-lg-12">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-6 col-lg-6">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Registration PDF</h5>
                        <div class="col-lg-12">
                            <div class="tab-content text-muted mt-3">
                                <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                     aria-labelledby="custom-v-pills-bank-gateway-tab">

                                    <form method="POST" action="{{ route('admin.about-company.update.pdf') }}"
                                          enctype="multipart/form-data">
                                        @csrf
                                        @method('PUT')
                                        <div class="row">
                                            <div class="col-lg-12">

                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Upload PDF</label>
                                                    <input class="form-control" type="file" id="formFile"
                                                           name="reg_pdf">
                                                </div>

                                                <div class="col-lg-12">
                                                    <div class="hstack gap-2 justify-content-end">
                                                        <button type="submit" class="btn btn-primary">Update</button>
                                                        <button type="button" class="btn btn-soft-success">Cancel
                                                        </button>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                            </div>

                                        </div>

                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection
@push('js_cdn')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="{{ asset('assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script>
    <script src="{{ asset('assets/js/pages/form-editor.init.js') }}"></script>
    <script>
        $(document).ready(function () {
            // Example: Show file names when files are selected
            $('input[type="file"]').on('change', function () {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.form-label').text(fileName);
            });
        });
    </script>

@endpush
