@extends('main')
@section('h_title', 'Add Drive Package')
@section('package_main', 'active')
@section('package_main_expand', 'true')
@section('package_show_main', 'show')
@section('drive_main', 'active')
@section('drive_show', 'show')
@section('drive_add', 'active')
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Add Drive Offer</h4>
                </div><!-- end card header -->
                <div class="card-body">

                    <form action="{{ route('admin.drive.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Offer Name</label>
                                    <input type="text" class="form-control" placeholder="Enter offer name"
                                           name="name" value="{{ old('name') }}"
                                           id="name">
                                    @error('name')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div><!--end col-->
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="buying_price" class="form-label">Buying Price</label>
                                    <input type="number" class="form-control" placeholder="Enter your buying price"
                                           name="buying_price" value="{{ old('buying_price') }}"
                                           id="buying_price">
                                    @error('buying_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="selling_price" class="form-label">Selling Price</label>
                                    <input type="number" class="form-control" placeholder="Enter selling price"
                                           name="selling_price" value="{{ old('selling_price') }}"
                                           id="selling_price">
                                    @error('selling_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="discount_price" class="form-label">Discount</label>
                                    <input type="number" class="form-control" placeholder="Enter discount price"
                                           name="discount_price" value="{{ old('discount_price') }}"
                                           id="discount_price">
                                    @error('discount_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="operator" class="form-label">Operator</label>
                                    <select id="operator" class="form-select" name="operator">
                                        <option selected disabled>Choose...</option>
                                        <option>Robi</option>
                                        <option>Airtel</option>
                                        <option>Skitto</option>
                                        <option>Teletalk</option>
                                        <option>Banglalink</option>
                                        <option>Grameenphone</option>
                                    </select>

                                    @error('operator')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="package" class="form-label">Package</label>
                                    <input type="text" class="form-control" placeholder="Package Type"
                                           name="package" value="Drive" disabled
                                           id="package">
                                    @error('package')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="validity" class="form-label">Validity</label>
                                    <input type="text" class="form-control" placeholder="Enter offer validity"
                                           value="{{ old('validity') }}"
                                           id="validity" name="validity">
                                    @error('validity')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection
