@extends('frontend.dashboard.main')
@push('css')
    <style>
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }

        .card h4 {
            font-size: 20px;
            font-weight: 700;
        }

        .card p {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.8);
        }

        .btn-icon-text {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-transform: uppercase;
            color: white;
        }

        .row > .col-lg-3 {
            margin-top: 20px;
        }

        .card-body {
            padding: 20px;
        }
    </style>
@endpush
@section('body')

    <div class="layout-specing">
        <div class="d-flex align-items-center justify-content-between">
            <div>
                <h6 class="text-muted mb-1">স্বাগত, {{ $user->name }}!</h6>
                <h5 class="mb-0">ড্যাশবোর্ড</h5>
            </div>

            <div class="mb-0 position-relative">
            </div>
        </div>

        <div class="row">
            <!-- Internet Offers Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-primary text-white text-center">
                    <div class="card-body">
                        <h4>সেন্ড মানি</h4>
                        <p>আপনার পছন্দের সেন্ড মানি পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.send-money.index') }}"
                           class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Minute Offers Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-danger text-white text-center">
                    <div class="card-body">
                        <h4>মোবাইল রিচার্জ</h4>
                        <p>আপনার পছন্দের রিচার্জ পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.recharge.index') }}"
                           class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Mobile Banking Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-info text-white text-center">
                    <div class="card-body">
                        <h4>পে-বিল</h4>
                        <p>আপনার পছন্দের পে-বিল পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.pay-bill.index') }}" class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Bank Transfer Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-warning text-white text-center">
                    <div class="card-body">
                        <h4>রেমিট্যান্স</h4>
                        <p>আপনার পছন্দের রেমিট্যান্স পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.remittance.index') }}" class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Internet Offers Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-primary text-white text-center">
                    <div class="card-body">
                        <h4>ব্যংক ট্রান্সফার</h4>
                        <p>আপনার পছন্দের ব্যংক ট্রান্সফার পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.banking.index') }}"
                           class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Minute Offers Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-danger text-white text-center">
                    <div class="card-body">
                        <h4>মোবাইল ব্যাংকিং</h4>
                        <p>আপনার পছন্দের মোবাইল ব্যাংকিং পরিষেবা পেতে এখানে ক্লিক করুন</p>
                        <a href="{{ route('user.m-banking.index') }}"
                           class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Mobile Banking Section -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card bg-info text-white text-center">
                    <div class="card-body">
                        <h4>হিস্ট্রি</h4>
                        <p>আপনার সকল হিস্ট্রি দেখতে এখানে ক্লিক করুনম</p>
                        <a href="{{ route('user.history') }}" class="btn btn-outline-light btn-icon-text">
                            এখানে ক্লিক করুন
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
     <!-- Approve Payment Modal -->
    <div class="modal fade" id="paymentModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
         aria-labelledby="paymentModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('user.payment.create') }}" method="POST">
                @csrf
                <div class="modal-content" style="background-color: white;">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editUserModalLabel">Payment</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>
                    <div class="modal-body">
                        <div class="row">

                            <div class="col-md-6 mb-2">
                                <label for="validationCustom10"
                                       class="form-label label text-secondary">Amount</label>
                                <div class="position-relative">
                                    <input type="number" class="form-control h-55" id="amount"
                                           placeholder="Enter your amount"
                                           name="amount">
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="validationCustom10"
                                       class="form-label label text-secondary"> <br> </label>
                                <div class="position-relative">
                                    <button type="submit"
                                            class="btn btn-success fw-medium text-white py-3 px-4 w-100"> Pay
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection
