<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <title>{{ $settings->brandName }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- favicon -->
    <link rel="shortcut icon" href="{{ asset($settings->favicon)}}">
    <!-- Bootstrap -->
    <link href="{{ asset('u_dash/assets/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- simplebar -->
    <link href="{{ asset('u_dash/assets/css/simplebar.css')}}" rel="stylesheet" type="text/css"/>

    <!-- Icons -->
    <link href="{{ asset('u_dash/assets/css/materialdesignicons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('u_dash/assets/css/tabler-icons.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="https://unicons.iconscout.com/release/v3.0.6/css/line.css')}}" rel="stylesheet">
    <!-- Css -->
    @stack('css')
    <link href="{{ asset('u_dash/assets/css/style.css')}}" rel="stylesheet" type="text/css" id="theme-opt"/>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

</head>

<body>
<!-- Loader -->
<div id="preloader">
    <div id="status">
        <div class="spinner">
            <div class="double-bounce1"></div>
            <div class="double-bounce2"></div>
        </div>
    </div>
</div>
<!-- Loader -->

<div class="page-wrapper landrick-theme toggled">
    @include('frontend.dashboard.extra.sidebar')
    <!-- sidebar-wrapper  -->

    <!-- Start Page Content -->
    <main class="page-content bg-light">
        @include('frontend.dashboard.extra.header')

        <div class="container-fluid">
            @yield('body')
        </div><!--end container-->

        @include('frontend.dashboard.extra.footer')
    </main>
    <!--End page-content" -->
</div>
<!-- page-wrapper -->

<!-- javascript -->
<script src="{{ asset('u_dash/assets/js/bootstrap.bundle.min.js')}}"></script>
<!-- simplebar -->
<script src="{{ asset('u_dash/assets/js/simplebar.min.js')}}"></script>
<!-- Icons -->
<script src="{{ asset('u_dash/assets/js/feather.min.js')}}"></script>
<!-- Chart -->
<script src="{{ asset('u_dash/assets/js/apexcharts.min.js')}}"></script>
<!-- Main Js -->
<script src="{{ asset('u_dash/assets/js/plugins.init.js')}}"></script>
<script src="{{ asset('u_dash/assets/js/app.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>

@stack('js')
@if (Session::has('message'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const message = "{{ Session::get('message') }}";
            const type = "{{ Session::get('alert-type', 'info') }}"; // Use 'info' as default type

            let toastOptions = {
                text: message,
                duration: 3000, // Duration in milliseconds
                gravity: "top", // 'top' or 'bottom'
                position: 'right', // 'left' or 'right'
                stopOnFocus: true // Prevent toast from hiding on hover
            };

            // Customize options based on the message type
            switch (type) {
                case 'success':
                    toastOptions.backgroundColor = "#28a745"; // Solid green for success
                    break;
                case 'error':
                    toastOptions.backgroundColor = "#dc3545"; // Solid red for error
                    break;
                case 'warning':
                    toastOptions.backgroundColor = "#ffc107"; // Solid yellow for warning
                    break;
                default:
                    toastOptions.backgroundColor = "#6c757d"; // Default solid color (gray)
            }

            Toastify(toastOptions).showToast();
        });
    </script>
@endif
<script>
    document.getElementById('viewProfile').addEventListener('click', function (e) {
        e.preventDefault(); // prevent href="#"
        Swal.fire({
            title: '{{ $user->name }}',
            text: 'আপনার প্রোফাইল আপডেট করার জন্য আমাদের অ্যাপ ডাউনলোড করে ব্যবহার করুন।',
            imageUrl: '{{ $user->profile }}',
            imageWidth: 100,
            imageHeight: 100,
            imageAlt: 'User profile picture',
            icon: 'info', // আইকন যুক্ত করা হয়েছে
            confirmButtonText: 'ঠিক আছে',
            confirmButtonColor: '#3085d6',
        });
    });

    @if(auth()->check() && auth()->user()->document && auth()->user()->document->status === 'Pending')
    document.addEventListener('DOMContentLoaded', function () {
        Swal.fire({
            title: 'ডকুমেন্ট যাচাই হচ্ছে',
            text: 'আপনার ডকুমেন্ট যাচাই প্রক্রিয়াধীন আছে।',
            icon: 'warning',
            showCancelButton: false,
            showConfirmButton: true,
            confirmButtonText: 'যোগাযোগ করুন',
            allowOutsideClick: false,
            allowEscapeKey: false,
            allowEnterKey: false,
            backdrop: true,
            didOpen: () => {
                Swal.getConfirmButton().addEventListener('click', () => {
                    Swal.fire({
                        title: 'যোগাযোগ করুন',
                        html: 'আপনার একাউন্ট ডকুমেন্ট যাচাই হচ্ছে।<br>সাপোর্ট এ কথা বলতে <strong>অ্যাপ ডাউনলোড করুন</strong>',
                        icon: 'info',
                        showConfirmButton: false, // ✅ removes the "ঠিক আছে" button
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        allowEnterKey: false,
                    });
                });

            }
        });
    });
    @endif

    document.addEventListener('DOMContentLoaded', function () {
        // Firebase configuration
        const firebaseConfig = {
            apiKey: "{{ env('FIREBASE_API_KEY') }}",
            authDomain: "{{ env('FIREBASE_AUTH_DOMAIN') }}",
            projectId: "{{ env('FIREBASE_PROJECT_ID') }}",
            {{--storageBucket: "{{ env('FIREBASE_STORAGE_BUCKET') }}",--}}
            messagingSenderId: "{{ env('FIREBASE_MESSAGING_SENDER_ID') }}",
            appId: "{{ env('FIREBASE_APP_ID') }}",
            measurementId: "{{ env('FIREBASE_MEASUREMENT_ID') }}"
        };

        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);

        const messaging = firebase.messaging();

        // Register the service worker
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('/firebase-messaging-sw.js')
                .then((registration) => {
                    // Request permission and get the device token
                    messaging.requestPermission()
                        .then(() => {
                            return messaging.getToken({
                                vapidKey: "{{env('FIREBASE_WEB_PUSH_CERTIFICATE_KEY')}}"
                            });
                        })
                        .then((token) => {
                            if (token) {
                                console.log('token: ', token);
                                // Use AJAX to submit the token
                                fetch('{{ route('user.update.token') }}', {
                                    method: 'PUT',
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                                    },
                                    body: JSON.stringify({fcm_token: token})
                                })
                                    .then(response => response.json())
                                    .then(data => {
                                        console.log('token updated: ', data);
                                    })
                                    .catch(error => {
                                        console.error('token error: ', error);
                                    });
                            } else {
                                console.error('No registration token available. Request permission to generate one.');
                            }
                        })
                        .catch((err) => {
                            console.error('An error occurred while retrieving token.', err);
                        });
                })
                .catch((error) => {
                    console.error('Service Worker registration failed:', error);
                });
        } else {
            console.error('Service Workers are not supported in this browser.');
        }

        // Handle incoming messages
        messaging.onMessage((payload) => {
            console.log('Message received. ', payload);
            const notificationTitle = payload.notification.title;
            const notificationOptions = {
                body: payload.notification.body,
                icon: payload.notification.icon
            };

            if (Notification.permission === 'granted') {
                new Notification(notificationTitle, notificationOptions);
            }
        });
    });
</script>
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Check if Ctrl is held down and keycode is not in the allowed list
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    // Fix for Ctrl+V not working in input elements
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Allow Ctrl+V specifically in input and textarea
        if (event.ctrlKey && event.keyCode === 86 && (event.target.tagName === "INPUT" || event.target.tagName === "TEXTAREA")) {
            return true;  // Allow Ctrl+V in input or textarea
        }

        // Block other Ctrl key combinations
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

</script>

</body>

</html>
