@extends('frontend.dashboard.main')
@section('body')
    <div class="layout-specing py-4">
        <div class="row">
            <!-- আইটেম তথ্য -->
            <div class="col-md-5 grid-margin mt-2">
                <div class="card shadow-sm border-0 rounded-lg">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <img src="{{ asset('assets/operators/' . $operator . '.png') }}"
                                 class="img-fluid rounded-circle border shadow-sm"
                                 style="width: 100px; height: 100px; margin-right: 10px"
                                 alt="{{ $item->name }}"/>
                            <div class="ml-4">
                                <h4 class="font-weight-bold text-primary">{{ $item->name }}</h4>
                                <p class="mb-2 text-secondary">
                                    <strong>Operator:</strong> {{ $item->getOperator->name ?? $item->operator }}</p>
                                <p class="mb-2 text-secondary"><strong>Validity:</strong> {{ $item->validity }}</p>
                                <p class="mb-2 text-secondary"><strong>Price:</strong> {{ $item->selling_price }} টাকা
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- অর্ডার ফর্ম -->
            <div class="col-md-6 grid-margin stretch-card  mt-2">
                <div class="card shadow-sm border-0 rounded-lg">
                    <div class="card-body">
                        <h5 class="font-weight-bold text-primary mb-4">Order Details</h5>
                            <form action="{{ route('user.packages.item.order', ['item_id' => $item->id]) }}" method="POST">

                            @csrf
                            <div class="form-group">
                                <label for="offer_number" class="font-weight-bold">Enter Number <span
                                        class="text-danger">*</span></label>
                                <input type="number" class="form-control shadow-sm" id="number" value="{{ old('number') }}"
                                       name="number"
                                       placeholder="Enter your mobile number" required>
                                @error('number')
                                <span class="text-danger small">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group mt-2">
                                <label for="password" class="font-weight-bold">Your Pin <span
                                        class="text-danger">*</span></label>
                                <input type="password" class="form-control shadow-sm" id="pin" name="pin"
                                       placeholder="Enter your pin" required>
                                @error('pin')
                                <span class="text-danger small">{{ $message }}</span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary btn-block btn-lg mt-4">Proceed</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
