@extends('frontend.dashboard.main')

@section('body')
    <div class="layout-specing py-4">
        <h2 class="mb-4">লেনদেনের ইতিহাস</h2>

        <p class="text-muted">মোট রেকর্ড: {{ $paginated->total() }}</p>

        @if($paginated->count())
            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>টাইপ</th>
                        <th>টাকা</th>
                        <th>স্ট্যাটাস</th>
                        <th>বিস্তারিত</th>
                        <th>তারিখ</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($paginated as $key => $history)
                        <tr>
                            <td>{{ $paginated->firstItem() + $key }}</td>
                            <td>{{ $history['type'] }}</td>
                            <td>{{ number_format((float)$history['amount'], 2) }} BDT</td>
                            <td>
                                @php
                                    $status = strtolower($history['status']);
                                @endphp
                                @if($status === 'pending')
                                    <span class="badge bg-warning text-dark">Pending</span>
                                @elseif($status === 'success' || $status === 'completed')
                                    <span class="badge bg-success">Success</span>
                                @elseif($status === 'failed' || $status === 'cancelled')
                                    <span class="badge bg-danger">Failed</span>
                                @else
                                    <span class="badge bg-secondary">{{ ucfirst($status) }}</span>
                                @endif
                            </td>
                            <td>{{ $history['details'] }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($history['created_at'])->format('d M Y, h:i A') }}
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4 d-flex justify-content-center">
                {!! $paginated->links('pagination::bootstrap-4') !!}
            </div>
        @else
            <div class="alert alert-info">
                কোনো লেনদেনের ইতিহাস পাওয়া যায়নি।
            </div>
        @endif
    </div>
@endsection
