@extends('frontend.dashboard.main')

@push('css')
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <style>
        /* Tab Navigation Styles */
        .nav-pills-custom .nav-link {
            border: 1px solid #ddd;
            border-radius: 50px;
            color: #555;
            padding: 10px 20px;
            text-transform: capitalize;
            transition: all 0.3s ease-in-out;
        }
        .nav-pills-custom .nav-link.active {
            background-color: #007bff;
            color: white;
            border-color: #007bff;
        }

        /* Card Design */
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.15);
        }
        .card img {
            border-radius: 10px;
            max-height: 60px;
        }

        /* Fonts & Text */
        .card h6 {
            font-weight: bold;
        }
        .card .text-danger {
            font-size: 16px;
            font-weight: bold;
        }
        .card .text-primary {
            font-size: 14px;
        }
        .install a {
            font-size: 14px;
            font-weight: bold;
            color: #007bff;
            text-decoration: none;
        }
        .install a:hover {
            text-decoration: underline;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .nav-pills-custom .nav-link {
                font-size: 12px;
                padding: 5px 10px;
            }
            .card img {
                max-height: 50px;
            }
        }
    </style>
@endpush

@section('body')
    <div class="layout-specing py-4">
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-md-10 mx-auto">

                        {{-- Operators Tab Navigation --}}
                        <ul class="nav nav-pills nav-pills-custom justify-content-center mb-4" id="pills-tab-custom" role="tablist">
                            @foreach($operators as $key => $name)
                                <li class="nav-item" style="margin: 5px;">
                                    <a class="nav-link {{ $loop->first ? 'active' : '' }}"
                                       id="pills-{{ $key }}-tab-custom"
                                       data-toggle="pill"
                                       href="#pills-{{ $key }}"
                                       role="tab"
                                       aria-controls="pills-{{ $key }}"
                                       aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                                        {{ $name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>

                        {{-- Tab Content --}}
                        <div class="tab-content tab-content-custom-pill" id="pills-tabContent-custom">
                            @foreach($operators as $key => $name)
                                <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}"
                                     id="pills-{{ $key }}"
                                     role="tabpanel"
                                     aria-labelledby="pills-{{ $key }}-tab-custom">
                                    <div class="row">
                                        @php
                                            // Filter items case-insensitive matching operator key
                                            $operatorItems = $items->filter(function($item) use ($key) {
                                                return strtolower($item->operator) === strtolower($key);
                                            });
                                        @endphp

                                        @forelse($operatorItems as $item)
                                            <div class="col-md-3 col-sm-6 mb-4">
                                                <div class="card p-3">
                                                    <div class="d-flex flex-row mb-3 align-items-center">
                                                        <img src="{{ asset('assets/operators/' . $key . '.png') }}" alt="{{ $name }}" style="width: 50px; height: auto;">
                                                        <div class="d-flex flex-column ml-3">
                                                            <span>{{ $name }}</span>
                                                            <span class="text-danger">{{ $item->selling_price }} টাকা</span>
                                                            <span class="text-primary">Validity: {{ $item->validity }}</span>
                                                        </div>
                                                    </div>
                                                    <h6>{{ $item->name }}</h6>
                                                    <div class="d-flex justify-content-between install mt-3">
                                                        <span></span>
                                                        <a href="{{ route('user.packages.details', [$item->operator, $item->id]) }}">
                                                            Order Now <i class="fa fa-angle-right"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                            <div class="col-md-12">
                                                <div class="alert alert-danger text-center" role="alert">
                                                    {{ __('No Items Found') }}
                                                </div>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function () {
            // ট্যাবে ক্লিক করলে URL hash সেট করো
            $('#pills-tab-custom a').on('click', function (e) {
                e.preventDefault();
                const tabId = $(this).attr('href');
                window.location.hash = tabId;
                $(this).tab('show');
            });

            // রিফ্রেশ হলে হ্যাশ দেখে সেই ট্যাব একটিভ করো
            const hash = window.location.hash;
            if (hash) {
                const tabLink = $('a[href="' + hash + '"]');
                if (tabLink.length) {
                    tabLink.tab('show');
                }
            }
        });
    </script>
@endpush
