@extends('frontend.dashboard.main')
@push('css')
    <style>
        .pagination-margin {
            margin-top: 15px;
            margin-bottom: 15px;
        }

        /* Responsive adjustments */
        @media (max-width: 991.98px) {
            .col-lg-6 {
                flex: 0 0 100%;
                max-width: 100%;
            }
        }

        /* Card custom styles */
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card-custom:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
        }

        .card-header {
            color: white;
            background: cornflowerblue;
            padding: 25px;
            font-size: 1rem;
            border-radius: 10px 10px 0 0;
        }

        .card-body {
            padding: 20px;
        }

        .preview-item {
            padding: 15px;
            border-bottom: 1px solid #e0e0e0;
            transition: background-color 0.3s ease;
            border-radius: 8px;
        }

        .preview-item:hover {
            background-color: #f1f1f1;
        }

        .preview-thumbnail img {
            border-radius: 50%;
            width: 40px;
            height: 40px;
        }

        .preview-item-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .text-dark {
            color: #333;
        }

        a:hover {
            text-decoration: none;
        }

        .pagination .page-item {
            margin: 0 5px;
        }

        .pagination .page-link {
            border-radius: 50%;
            padding: 8px 15px;
            background-color: #007bff;
            color: white;
            border: none;
        }

        /* Badge Styling */
        .badge-custom-info {
            background-color: #17a2b8;
            color: white;
            padding: 5px 10px;
            border-radius: 25px;
        }
    </style>
@endpush
@section('body')
    <div class="container">
        <div class="layout-specing">
            <div class="col-xl-6 col-lg-6 mt-4">
                <div class="card card-custom mb-3">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ __('মোবাইল ব্যাংকিং') }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="preview-list">
                            @foreach($mBankings as $item)
                                <a href="{{ route('user.add-money.mobile.proceed.addmoney', $item->id) }}">
                                    <div class="preview-item">
                                        <div class="preview-thumbnail">
                                            <img src="{{ asset($item->logo) }}" alt="{{ $item->method_name }}"
                                                 class="img-fluid rounded-circle"/>
                                        </div>
                                        <div class="preview-item-content">
                                            <div class="flex-grow-1">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <h6 class="preview-subject text-dark">{{__('মেথড: '. $item->name) }}</h6>
                                                    </div>
                                                    <div class="col-6 text-right">
                                                        <span
                                                                class="badge badge-custom-info">{{ __('টাইপ: ' . $item->sending_type) }}</span>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <span
                                                                class="preview-subject text-dark">{{ __('নাম্বার: ') . $item->number }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                        <div class="pagination-margin">
                            {{ $mBankings->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
