@extends('frontend.dashboard.main')
@push('css')
    <style>
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s, box-shadow 0.2s;
            overflow: hidden; /* Ensure content stays within the card */
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .card img {
            border-radius: 20%;
            border: 2px solid #f1f1f1;
            object-fit: fill; /* Ensures the image fits nicely */
            width: 80px;
            height: 80px;
        }

        .card h6 {
            font-weight: bold;
            margin: 0;
        }

        .install a {
            font-weight: bold;
            transition: color 0.2s;
        }

        .install a:hover {
            color: #007bff;
        }

        .col-md-4 {
            margin-top: 20px;
        }

        .d-flex.align-items-center {
            gap: 15px; /* Ensures proper spacing between image and text */
        }
    </style>
@endpush
@section('body')
    <div class="container">
        <div class="layout-specing">
            <div class="row">

                @foreach($mBanks as $mBank)
                    <div class="col-md-4 col-sm-6">
                        <div class="card p-3">
                            <div class="d-flex align-items-center">
                                <img src="{{ asset($mBank->logo) }}" alt="{{ $mBank->name }}">
                                <div class="ml-3">
                                    <h6>{{ $mBank->name }}</h6>
                                    <p class="text-muted small mb-0">নিরাপদ এবং দ্রুত ব্যাংকিং</p>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center install mt-3">
                                <span></span>
                                <a href="{{ route('user.m-banking.view', $mBank->id) }}"
                                   class="text-primary">
                                    অর্ডার করুন <i class="fa fa-angle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </div>
@endsection
