@extends('frontend.dashboard.main')
@push('css')
    <style>
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }

        .card-custom:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(-5px);
        }

        .form-control {
            border-radius: 8px;
            padding: 0.8rem;
            font-size: 1rem;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        .btn-clipboard {
            background-color: #28a745;
            color: white;
            border-radius: 5px;
            padding: 0.5rem 1rem;
            font-size: 14px;
        }

        .btn-clipboard:hover {
            background-color: #218838;
        }

        .img-lg {
            height: 92px;
            width: 92px;
            border-radius: 50%;
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 15px;
            }

            .img-lg {
                width: 50px;
                height: 50px;
            }

            .btn-clipboard {
                font-size: 12px;
                padding: 0.4rem 0.8rem;
            }
        }
    </style>
@endpush

@section('body')
    <div class="layout-specing">
        <div class="row">

            <div class="col-md-2 grid-margin"></div>
            <div class="col-md-4 grid-margin">
                <div class="card card-custom">
                    <div class="card-body d-flex flex-row">
                        <img src="{{ asset($bank->logo) }}" class="img-lg" alt="{{ $bank->bank_name }}"/>
                        <div class="ml-3">
                            <h6 class="font-weight-bold">{{$bank->bank_name }}</h6>
                            <p class="text-muted">{{ __('একাউন্ট নামঃ '). $bank->ac_holder_name }}</p>
                            <p class="text-dark font-weight-bold">একাউন্ট নাম্বারঃ
                                <span id="bank_ac_number">{{ $bank->ac_holder_number }}</span>
                                <button type="button" class="btn btn-sm btn-clipboard ml-2"
                                        data-clipboard-action="copy"
                                        data-clipboard-target="#bank_ac_number">
                                    কপি করুন
                                </button>
                            </p>
                            <p class="text-dark font-weight-bold mb-0">ব্রাঞ্চঃ {{ $bank->branch_name }}</p>
                            <p class="text-dark font-weight-bold mb-0">দেশঃ {{ $bank->country_name }}</p>
                            <p class="text-dark font-weight-bold mb-0">আইবিএন নাম্বারঃ {{ $bank->ibn_no }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Money Request Form -->
            <div class="col-md-4 grid-margin">
                <div class="card card-custom">
                    <div class="card-body">
                        <form method="POST"
                              action="{{ route('user.add-money.banking.deposit', $bank->id) }}"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="senderNumber">একাউন্ট নাম্বার <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="senderNumber" name="sender_number"
                                       placeholder="একাউন্ট নাম্বার" required>
                            </div>

                            <div class="form-group mt-2">
                                <label for="amount">পরিমাণ <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="amount" name="amount"
                                       placeholder="টাকার পরিমাণ লিখুন" required>
                            </div>

                            <div class="form-group mt-2">
                                <label>রিসিপ্ট স্ক্রিনশট</label>
                                <input type="file" name="screenshot" class="form-control">
                            </div>

                            <div class="form-group mt-2 mb-3 ">
                                <label for="pin">পিন <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="pin" name="pin"
                                       placeholder="৪ সংখ্যার পিন লিখুন" required>
                                @error('pin')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">সাবমিট</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Optional: Another Column -->
        </div>
    </div>
@endsection

@push('js')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const clipboard = new ClipboardJS('.btn-clipboard');
            clipboard.on('success', function (e) {
                Swal.fire({
                    icon: 'success',
                    title: 'কপি সফল হয়েছে!',
                    text: e.text,
                    timer: 1500,
                    showConfirmButton: false
                });
            });

            clipboard.on('error', function (e) {
                Swal.fire({
                    icon: 'error',
                    title: 'কপি ব্যর্থ হয়েছে!',
                    text: 'অনুগ্রহ করে ম্যানুয়ালি কপি করুন।',
                });
            });
        });
    </script>
@endpush
