@extends('frontend.dashboard.main')
@push('css')
    <style>
        /* Custom Styles for Cards */
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }

        .card-custom:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(-5px);
        }

        /* Flexbox alignment for better layout */
        .d-flex {
            display: flex;
            align-items: center;
        }

        .ml-3 {
            margin-left: 1rem;
        }

        /* Button Styling */
        .btn-clipboard {
            background-color: #28a745;
            color: white;
            border-radius: 5px;
            padding: 0.5rem 1rem;
            font-size: 14px;
        }

        .btn-clipboard:hover {
            background-color: #218838;
        }

        .form-group label {
            font-weight: 600;
            color: #333;
        }

        /* Input Field Styling */
        .form-control {
            border-radius: 8px;
            padding: 0.8rem;
            font-size: 1rem;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        /* Custom responsive tweaks */
        @media (max-width: 768px) {
            .card-body {
                padding: 15px;
            }

            .img-lg {
                width: 50px;
                height: 50px;
            }
        }
    </style>
@endpush

@section('body')
    <div class="layout-specing">
        <div class="container">

            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin">
                    <div class="card card-custom">
                        <div class="card-body d-flex flex-row align-items-center">
                            <img src="{{ asset($bank->logo) }}" class="img-lg" style="height: 92px; width: 92px;"
                                 alt="{{ $bank->name }}"/>
                            <div class="ml-3">
                                <h6 class="font-weight-bold text-dark">{{ $bank->name }}</h6>
                                <p class="text-muted">নিরাপদ এবং দ্রুত ব্যাংকিং</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin stretch-card">
                    <div class="card card-custom">
                        <div class="card-body">
                            <form class="forms-sample"
                                  action="{{ route('user.banking.proceed', $bank->name) }}"
                                  method="POST">
                                @csrf
                                <div class="form-group mb-2">
                                    <label for="ac_number">{{ $bank->name }} একাউন্ট নাম্বার <span
                                                class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="ac_number" name="ac_number"
                                           value="{{ old('ac_number') }}"
                                           placeholder=" {{ $bank->name }} এর একাউন্ট নাম্বার লিখুন">

                                    @error('ac_number')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="ac_name">একাউন্টধারীর নাম <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="ac_name" name="ac_name"
                                           value="{{ old('ac_name') }}"
                                           placeholder="একাউন্টধারীর নাম লিখুন">

                                    @error('ac_name')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="district_name">ব্রাঞ্চ নাম <span class="text-danger">*</span> </label>
                                    <input type="text" class="form-control" id="district_name" name="district_name"
                                           value="{{ old('district_name') }}"
                                           placeholder="ব্রাঞ্চ নাম লিখুন">

                                    @error('district_name')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="reference">রেফারেন্স</label>
                                    <input type="text" class="form-control" id="reference" name="reference"
                                           value="{{ old('reference') }}"
                                           placeholder="রেফারেন্স লিখুন (Optional)">

                                    @error('reference')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="amount">পরিমাণ <span class="text-danger">*</span> </label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                           value="{{ old('amount') }}"
                                           placeholder="টাকার পরিমাণ লিখুন">

                                    @error('amount')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="pin">পিন <span class="text-danger">*</span> </label>
                                    <input type="number" class="form-control" id="pin" name="pin"
                                           placeholder="৪ সংখ্যার পিন লিখুন">

                                    @error('pin')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-primary mr-2">সাবমিট</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const clipboard = new ClipboardJS('.btn-clipboard');
            clipboard.on('success', function (e) {
                Swal.fire({
                    icon: 'success',
                    title: 'কপি সফল হয়েছে!',
                    text: e.text,
                    timer: 1500,
                    showConfirmButton: false
                });
            });

            clipboard.on('error', function (e) {
                Swal.fire({
                    icon: 'error',
                    title: 'কপি ব্যর্থ হয়েছে!',
                    text: 'অনুগ্রহ করে ম্যানুয়ালি কপি করুন।',
                });
            });
        });
    </script>
@endpush
