@extends('frontend.dashboard.main')
@push('css')
    <style>
        /* Custom Styles for Cards */
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }

        .card-custom:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(-5px);
        }

        /* Flexbox alignment for better layout */
        .d-flex {
            display: flex;
            align-items: center;
        }

        .ml-3 {
            margin-left: 1rem;
        }

        /* Button Styling */
        .btn-clipboard {
            background-color: #28a745;
            color: white;
            border-radius: 5px;
            padding: 0.5rem 1rem;
            font-size: 14px;
        }

        .btn-clipboard:hover {
            background-color: #218838;
        }

        .form-group label {
            font-weight: 600;
            color: #333;
        }

        /* Input Field Styling */
        .form-control {
            border-radius: 8px;
            padding: 0.8rem;
            font-size: 1rem;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        /* Custom responsive tweaks */
        @media (max-width: 768px) {
            .card-body {
                padding: 15px;
            }

            .mobile_banking {
                margin-top: 15px;
            }

            .img-lg {
                width: 50px;
                height: 50px;
            }

            .btn-clipboard {
                font-size: 12px;
                padding: 0.4rem 0.8rem;
            }
        }
    </style>
@endpush
@section('body')
    <div class="container">
        <div class="layout-specing">
            <div class="row">
                <!-- Mobile Banking Card -->
                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin">
                    <div class="card card-custom">
                        <div class="card-body d-flex flex-row align-items-center">
                            <img src="{{ asset($mBanking->logo) }}" class="rounded-circle"
                                 style="height: 92px; width: 92px"
                                 alt="{{ $mBanking->name }}"/>
                            <div class="ml-3">
                                <h6 class="font-weight-bold text-dark">{{ $mBanking->name }}</h6>
                                <p class="text-muted">{{ $mBanking->sending_type }}</p>
                                <p class="mt-2 text-primary font-weight-bold">
                                    <span id="copyNumberText">{{ $mBanking->number }}</span>
                                    <button type="button" class="btn btn-sm btn-outline-info btn-clipboard ml-3"
                                            data-clipboard-action="copy" data-clipboard-target="#copyNumberText">
                                        <i class="fas fa-copy"></i> কপি করুন
                                    </button>
                                </p>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- Money Request Form -->
                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin mobile_banking">
                    <div class="card card-custom">
                        <div class="card-body">
                            <form class="forms-sample"
                                  action="{{ route('user.add-money.mBanking.deposit', $mBanking->id) }}"
                                  method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="amount">পরিমাণ <span class="text-danger">*</span> </label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                           value="{{ old('amount') }}"
                                           placeholder="টাকার পরিমাণ লিখুন" required>
                                    @error('amount')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group mt-2">
                                    <label for="senderNumber">নাম্বার <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="senderNumber" name="sender_number"
                                           value="{{ old('sender_number') }}"
                                           placeholder="যে নাম্বার থেকে টাকা পাঠানো হয়েছে" required>
                                    @error('sender_number')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group mt-2">
                                    <label for="trx_id">ট্রাঞ্জেকশন আইডি <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="trx_id" name="trx_id"
                                           value="{{ old('trx_id') }}"
                                           placeholder="ট্রাঞ্জেকশন আইডি লিখুন" required>
                                    @error('trx_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mt-2">
                                    <label for="pin">পিন <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="pin" name="pin"
                                           placeholder="৪ সংখ্যার পিন লিখুন" required>
                                    @error('pin')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-primary mr-2 mt-2">সাবমিট</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const clipboard = new ClipboardJS('.btn-clipboard');
            clipboard.on('success', function (e) {
                Swal.fire({
                    icon: 'success',
                    title: 'কপি সফল হয়েছে!',
                    text: e.text,
                    timer: 1500,
                    showConfirmButton: false
                });
            });

            clipboard.on('error', function (e) {
                Swal.fire({
                    icon: 'error',
                    title: 'কপি ব্যর্থ হয়েছে!',
                    text: 'অনুগ্রহ করে ম্যানুয়ালি কপি করুন।',
                });
            });
        });
    </script>
@endpush
