@extends('frontend.dashboard.main')
@section('body')
    <div class="layout-specing py-4">
        <div class="row">
            <div class="col-lg-4 mt-4">
                <div class="card border-0 rounded shadow">
                    <div class="card-body">
                        <h5 class="text-md-start text-center mb-0">Personal Detail :</h5>

                        <div class="mt-4 text-md-start text-center d-sm-flex">
                            <img src="{{ asset($user->profile) }}"
                                 class="avatar float-md-left avatar-medium rounded-circle shadow me-md-4"
                                 alt="{{ $user->name }}">
                        </div>

                        <form method="POST" action="{{ route("user.profile.update") }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Username</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="user" class="fea icon-sm icons"></i>
                                            <input type="text" class="form-control ps-5" value="{{ $user->username }}"
                                                   disabled
                                                   readonly>
                                        </div>
                                    </div>
                                </div><!--end col-->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="user-check" class="fea icon-sm icons"></i>
                                            <input name="name" id="name" type="text" class="form-control ps-5"
                                                   value="{{ $user->name }}" placeholder="Full Name :">
                                            @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div><!--end col-->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Your Phone</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="phone" class="fea icon-sm icons"></i>
                                            <input name="number" id="number" type="number" class="form-control ps-5"
                                                   value="{{ $user->phone }}" placeholder="Your phone :">
                                            @error('number')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Your Email</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="mail" class="fea icon-sm icons"></i>
                                            <input name="email" id="email" type="email" class="form-control ps-5"
                                                   value="{{ $user->email }}" placeholder="Your email :" readonly
                                                   disabled>
                                        </div>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Your Profile</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="image" class="fea icon-sm icons"></i>
                                            <input name="profile" id="profile" type="file" class="form-control ps-5">
                                            @error('profile')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div><!--end col-->


                            </div><!--end row-->
                            <div class="row">
                                <div class="col-sm-12">
                                    <input type="submit" id="submit" name="send" class="btn btn-primary"
                                           value="Save Changes">
                                </div><!--end col-->
                            </div><!--end row-->
                        </form><!--end form-->
                    </div>
                </div>
            </div><!--end col-->

            <div class="col-lg-4 mt-4">
                <div class="card border-0 rounded shadow p-4">
                    <h5 class="mb-0">Change password :</h5>
                    <form action="{{ route("user.profile.password.update") }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">Old password :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5" placeholder="Old password"  value="{{ old('old_password') }}"
                                               name="old_password"
                                               required="">
                                        @error('old_password')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">New password :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5" placeholder="New password"
                                               name="new_password" value="{{ old('new_password') }}"
                                               required="">
                                        @error('new_password')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">Re-type New password :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5"
                                               placeholder="Re-type New password" name="confirm_password"  value="{{ old('confrirm_password') }}"
                                               required="">
                                        @error('confirm_password')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-12 mt-2 mb-0">
                                <button class="btn btn-primary">Save password</button>
                            </div><!--end col-->
                        </div><!--end row-->
                    </form>
                </div>

            </div><!--end col-->

            <div class="col-lg-4 mt-4">
                <div class="card border-0 rounded shadow p-4">
                    <h5 class="mb-0">Change Pin :</h5>
                    <form action="{{ route("user.profile.pin.update") }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">Old pin :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5" placeholder="Old pin"
                                               name="old_pin"
                                               required="">
                                        @error('old_pin')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">New pin :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5" placeholder="New pin"
                                               name="new_pin"
                                               required="">
                                        @error('new_pin')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">Re-type New pin :</label>
                                    <div class="form-icon position-relative">
                                        <i data-feather="key" class="fea icon-sm icons"></i>
                                        <input type="password" class="form-control ps-5" name="confirm_pin"
                                               placeholder="Re-type New pin"
                                               required="">
                                        @error('confirm_pin')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 mt-2 mb-0">
                                <button class="btn btn-primary">Save pin</button>
                            </div><!--end col-->
                        </div><!--end row-->
                    </form>
                </div>

            </div><!--end col-->

        </div><!--end row-->
    </div>
@endsection
