@extends('frontend.dashboard.main')
@push('css')
    <style>
        /* Custom Styles for Cards */
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }

        .card-custom:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(-5px);
        }

        /* Input Field Styling */
        .form-control {
            border-radius: 8px;
            padding: 0.8rem;
            font-size: 1rem;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        /* Custom responsive tweaks */
        @media (max-width: 768px) {
            .card-body {
                padding: 15px;
            }

            .mobile_banking {
                margin-top: 15px;
            }
        }
    </style>
@endpush
@section('body')
    <div class="container">
        <div class="layout-specing">
            <div class="row">
                <!-- Money Request Form -->
                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin mobile_banking">
                    <div class="card card-custom">
                        <div class="card-title pt-3 ps-4">
                            <h6>রেমিট্যান্স</h6>
                        </div>
                        <hr>
                        <div class="card-body">
                            <form class="forms-sample"
                                  action="{{ route('user.remittance.proceed') }}"
                                  method="POST">
                                @csrf
                                <div class="form-group mb-2">
                                    <label for="recipientNumber">গ্রহণকারীর নাম্বার <span
                                                class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="recipientNumber" name="recipientNumber"
                                           value="{{ old('recipientNumber') }}"
                                           placeholder="গ্রহণকারীর নাম্বার" required>
                                    @error('recipientNumber')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="recipientName">গ্রহণকারীর নাম <span
                                                class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="recipientName" name="recipientName"
                                           value="{{ old('recipientName') }}"
                                           placeholder="গ্রহণকারীর নাম" required>
                                    @error('recipientName')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <div class="mb-0">
                                        <label for="account_number">ব্যাংক <span
                                                    class="text-danger">*</span></label>
                                        <select class="form-select form-control" name="bankName" required>
                                            <option selected disabled>ব্যাংক নির্বাচন করুন</option>
                                            @foreach($remittance as $item)
                                                <option
                                                        value="{{ $item->name }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                <div class="form-group mb-2">
                                    <label for="senderName">প্রেরণকারীর নাম <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="senderName" name="senderName"
                                           value="{{ old('senderName') }}"
                                           placeholder="প্রেরণকারীর নাম লিখুন" required>
                                    @error('senderName')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mb-2">
                                    <label for="senderNumber">প্রেরণকারীর নাম্বার <span class="text-danger">*</span>
                                    </label>
                                    <input type="number" class="form-control" id="senderNumber"
                                           name="senderNumber"
                                           value="{{ old('senderNumber') }}"
                                           placeholder="প্রেরণকারীর নাম্বার লিখুন" required>
                                    @error('senderNumber')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="transferAmount">পরিমাণ <span class="text-danger">*</span> </label>
                                    <input type="number" class="form-control" id="transferAmount" name="transferAmount"
                                           value="{{ old('transferAmount') }}"
                                           placeholder="টাকার পরিমাণ লিখুন" required>
                                    @error('transferAmount')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mt-2">
                                    <label for="pin">পিন <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="pin" name="pin"
                                           placeholder="৪ সংখ্যার পিন লিখুন" required>
                                    @error('pin')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-primary mr-2 mt-2">সাবমিট</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
