@extends('frontend.dashboard.main')
@push('css')
    <style>
        /* Custom Styles for Cards */
        .card-custom {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }

        .card-custom:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(-5px);
        }

        /* Input Field Styling */
        .form-control {
            border-radius: 8px;
            padding: 0.8rem;
            font-size: 1rem;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        /* Custom responsive tweaks */
        @media (max-width: 768px) {
            .card-body {
                padding: 15px;
            }

            .mobile_banking {
                margin-top: 15px;
            }
        }
    </style>
@endpush
@section('body')
    <div class="container">
        <div class="layout-specing">
            <div class="row">
                <!-- Money Request Form -->
                <div class="col-lg-6 col-md-12 col-sm-12 grid-margin mobile_banking">
                    <div class="card card-custom">
                        <div class="card-title pt-3 ps-4">
                            <h6>সেন্ড মানি</h6>
                        </div>
                        <hr>
                        <div class="card-body">
                            <form class="forms-sample"
                                  action="{{ route('user.send-money.proceed') }}"
                                  method="POST">
                                @csrf
                                <div class="form-group mb-2">
                                    <label for="account_number">নাম্বার <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="account_number" name="account_number"
                                           value="{{ old('account_number') }}"
                                           placeholder="একাউন্ট নাম্বার" required>
                                    @error('account_number')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="amount">পরিমাণ <span class="text-danger">*</span> </label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                           value="{{ old('amount') }}"
                                           placeholder="টাকার পরিমাণ লিখুন" required>
                                    @error('amount')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group mt-2">
                                    <label for="pin">পিন <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="pin" name="pin"
                                           placeholder="৪ সংখ্যার পিন লিখুন" required>
                                    @error('pin')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-primary mr-2 mt-2">সাবমিট</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
